/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.resourcemanager.implementation.crud;

import com.azure.core.management.exception.ManagementException;
import com.azure.resourcemanager.AzureResourceManager;
import com.azure.resourcemanager.servicebus.models.ServiceBusSubscription;
import com.azure.resourcemanager.servicebus.models.Topic;
import com.azure.spring.core.properties.resource.AzureResourceMetadata;
import com.azure.spring.resourcemanager.implementation.crud.AbstractResourceCrud;
import com.azure.spring.resourcemanager.implementation.crud.ServiceBusTopicCrud;
import reactor.util.function.Tuple3;
import reactor.util.function.Tuples;

public class ServiceBusTopicSubscriptionCrud
extends AbstractResourceCrud<ServiceBusSubscription, Tuple3<String, String, String>> {
    public ServiceBusTopicSubscriptionCrud(AzureResourceManager azureResourceManager, AzureResourceMetadata azureResourceMetadata) {
        super(azureResourceManager, azureResourceMetadata);
    }

    @Override
    String getResourceName(Tuple3<String, String, String> key) {
        return (String)key.getT3();
    }

    @Override
    String getResourceType() {
        return ServiceBusSubscription.class.getSimpleName();
    }

    @Override
    public ServiceBusSubscription internalGet(Tuple3<String, String, String> subscriptionCoordinate) {
        try {
            return (ServiceBusSubscription)((Topic)new ServiceBusTopicCrud(this.resourceManager, this.resourceMetadata).get(Tuples.of((Object)((String)subscriptionCoordinate.getT1()), (Object)((String)subscriptionCoordinate.getT2())))).subscriptions().getByName((String)subscriptionCoordinate.getT2());
        }
        catch (ManagementException e) {
            if (e.getResponse().getStatusCode() == 404) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public ServiceBusSubscription internalCreate(Tuple3<String, String, String> subscriptionCoordinate) {
        return (ServiceBusSubscription)((ServiceBusSubscription.DefinitionStages.Blank)((Topic)new ServiceBusTopicCrud(this.resourceManager, this.resourceMetadata).getOrCreate(Tuples.of((Object)((String)subscriptionCoordinate.getT1()), (Object)((String)subscriptionCoordinate.getT2())))).subscriptions().define((String)subscriptionCoordinate.getT3())).create();
    }
}

