/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.resourcemanager.implementation.crud;

import com.azure.core.management.exception.ManagementException;
import com.azure.resourcemanager.AzureResourceManager;
import com.azure.resourcemanager.storage.models.StorageAccount;
import com.azure.spring.core.properties.resource.AzureResourceMetadata;
import com.azure.spring.resourcemanager.implementation.crud.AbstractResourceCrud;

public class StorageAccountCrud
extends AbstractResourceCrud<StorageAccount, String> {
    public StorageAccountCrud(AzureResourceManager azureResourceManager, AzureResourceMetadata azureResourceMetadata) {
        super(azureResourceManager, azureResourceMetadata);
    }

    @Override
    String getResourceName(String key) {
        return key;
    }

    @Override
    String getResourceType() {
        return StorageAccount.class.getSimpleName();
    }

    @Override
    public StorageAccount internalGet(String key) {
        try {
            return (StorageAccount)this.resourceManager.storageAccounts().getByResourceGroup(this.resourceMetadata.getResourceGroup(), key);
        }
        catch (ManagementException e) {
            if (e.getResponse().getStatusCode() == 404) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public StorageAccount internalCreate(String key) {
        return (StorageAccount)((StorageAccount.DefinitionStages.WithCreate)((StorageAccount.DefinitionStages.WithGroup)((StorageAccount.DefinitionStages.Blank)this.resourceManager.storageAccounts().define(key)).withRegion(this.resourceMetadata.getRegion())).withExistingResourceGroup(this.resourceMetadata.getResourceGroup())).create();
    }
}

