/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.resourcemanager.provisioning.eventhubs;

import com.azure.resourcemanager.AzureResourceManager;
import com.azure.spring.core.properties.resource.AzureResourceMetadata;
import com.azure.spring.resourcemanager.implementation.crud.EventHubNamespaceCrud;
import com.azure.spring.resourcemanager.implementation.crud.EventHubsConsumerGroupCrud;
import com.azure.spring.resourcemanager.implementation.crud.EventHubsCrud;
import com.azure.spring.resourcemanager.provisioning.eventhubs.EventHubsProvisioner;
import reactor.util.function.Tuples;

public class DefaultEventHubsProvisioner
implements EventHubsProvisioner {
    private final EventHubNamespaceCrud namespaceCrud;
    private final EventHubsCrud eventHubsCrud;
    private final EventHubsConsumerGroupCrud consumerGroupCrud;

    public DefaultEventHubsProvisioner(AzureResourceManager azureResourceManager, AzureResourceMetadata azureResourceMetadata) {
        this.namespaceCrud = new EventHubNamespaceCrud(azureResourceManager, azureResourceMetadata);
        this.eventHubsCrud = new EventHubsCrud(azureResourceManager, azureResourceMetadata);
        this.consumerGroupCrud = new EventHubsConsumerGroupCrud(azureResourceManager, azureResourceMetadata);
    }

    @Override
    public void provisionNamespace(String namespace) {
        this.namespaceCrud.getOrCreate(namespace);
    }

    @Override
    public void provisionEventHub(String namespace, String eventHub) {
        this.eventHubsCrud.getOrCreate(Tuples.of((Object)namespace, (Object)eventHub));
    }

    @Override
    public void provisionConsumerGroup(String namespace, String eventHub, String consumerGroup) {
        this.consumerGroupCrud.getOrCreate(Tuples.of((Object)namespace, (Object)eventHub, (Object)consumerGroup));
    }
}

