/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.resourcemanager.implementation.crud;

import com.azure.core.management.exception.ManagementException;
import com.azure.resourcemanager.AzureResourceManager;
import com.azure.resourcemanager.servicebus.models.ServiceBusSubscription;
import com.azure.resourcemanager.servicebus.models.Topic;
import com.azure.spring.cloud.core.properties.resource.AzureResourceMetadata;
import com.azure.spring.cloud.resourcemanager.implementation.crud.AbstractResourceCrud;
import com.azure.spring.cloud.resourcemanager.implementation.crud.ServiceBusTopicCrud;
import reactor.util.function.Tuple3;
import reactor.util.function.Tuples;

public class ServiceBusTopicSubscriptionCrud
extends AbstractResourceCrud<ServiceBusSubscription, Tuple3<String, String, String>> {
    private ServiceBusTopicCrud serviceBusTopicCrud;

    public ServiceBusTopicSubscriptionCrud(AzureResourceManager azureResourceManager, AzureResourceMetadata azureResourceMetadata) {
        this(azureResourceManager, azureResourceMetadata, new ServiceBusTopicCrud(azureResourceManager, azureResourceMetadata));
    }

    ServiceBusTopicSubscriptionCrud(AzureResourceManager azureResourceManager, AzureResourceMetadata azureResourceMetadata, ServiceBusTopicCrud serviceBusTopicCrud) {
        super(azureResourceManager, azureResourceMetadata);
        this.serviceBusTopicCrud = serviceBusTopicCrud;
    }

    @Override
    String getResourceName(Tuple3<String, String, String> key) {
        return (String)key.getT3();
    }

    @Override
    String getResourceType() {
        return ServiceBusSubscription.class.getSimpleName();
    }

    @Override
    public ServiceBusSubscription internalGet(Tuple3<String, String, String> subscriptionCoordinate) {
        try {
            Topic topic = (Topic)this.serviceBusTopicCrud.get(Tuples.of((Object)((String)subscriptionCoordinate.getT1()), (Object)((String)subscriptionCoordinate.getT2())));
            return topic == null ? null : (ServiceBusSubscription)topic.subscriptions().getByName((String)subscriptionCoordinate.getT3());
        }
        catch (ManagementException e) {
            if (e.getResponse().getStatusCode() == 404) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public ServiceBusSubscription internalCreate(Tuple3<String, String, String> subscriptionCoordinate) {
        return (ServiceBusSubscription)((ServiceBusSubscription.DefinitionStages.Blank)((Topic)this.serviceBusTopicCrud.getOrCreate(Tuples.of((Object)((String)subscriptionCoordinate.getT1()), (Object)((String)subscriptionCoordinate.getT2())))).subscriptions().define((String)subscriptionCoordinate.getT3())).create();
    }
}

