/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.resourcemanager.implementation.crud;

import com.azure.core.management.exception.ManagementException;
import com.azure.resourcemanager.AzureResourceManager;
import com.azure.spring.cloud.core.properties.resource.AzureResourceMetadata;
import com.azure.spring.cloud.resourcemanager.implementation.crud.ResourceCrud;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.util.StopWatch;

public abstract class AbstractResourceCrud<T, K>
implements ResourceCrud<T, K> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractResourceCrud.class);
    static final int RESOURCE_NOT_FOUND = 404;
    protected final AzureResourceManager resourceManager;
    protected final AzureResourceMetadata resourceMetadata;

    protected AbstractResourceCrud(@NonNull AzureResourceManager resourceManager, @NonNull AzureResourceMetadata resourceMetadata) {
        this.resourceManager = resourceManager;
        this.resourceMetadata = resourceMetadata;
    }

    @Override
    public boolean exists(K key) {
        boolean exists;
        boolean bl = exists = this.get(key) != null;
        if (!exists) {
            LOGGER.debug("{} '{}' does not exist.", (Object)this.getResourceType(), (Object)this.getResourceName(key));
        }
        return exists;
    }

    @Override
    public T get(K key) {
        T t;
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        String resourceType = this.getResourceType();
        String name = this.getResourceName(key);
        try {
            LOGGER.info("Fetching {} with name '{}' ...", (Object)resourceType, (Object)name);
            t = this.internalGet(key);
        }
        catch (ManagementException e) {
            try {
                String message = String.format("Fetching %s with name '%s' failed due to: %s", resourceType, name, e.toString());
                throw new RuntimeException(message, e);
            }
            catch (Throwable throwable) {
                stopWatch.stop();
                LOGGER.info("Fetching {} with name '{}' finished in {} seconds", new Object[]{resourceType, name, stopWatch.getTotalTimeMillis() / 1000L});
                throw throwable;
            }
        }
        stopWatch.stop();
        LOGGER.info("Fetching {} with name '{}' finished in {} seconds", new Object[]{resourceType, name, stopWatch.getTotalTimeMillis() / 1000L});
        return t;
    }

    @Override
    public T create(K key) {
        T t;
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        String resourceType = this.getResourceType();
        String name = this.getResourceName(key);
        try {
            LOGGER.info("Creating {} with name '{}' ...", (Object)resourceType, (Object)name);
            t = this.internalCreate(key);
        }
        catch (ManagementException e) {
            try {
                String message = String.format("Creating %s with name '%s' failed due to: %s", resourceType, name, e.toString());
                throw new RuntimeException(message, e);
            }
            catch (Throwable throwable) {
                stopWatch.stop();
                LOGGER.info("Creating {} with name '{}' finished in {} seconds", new Object[]{this.getResourceType(), name, stopWatch.getTotalTimeMillis() / 1000L});
                throw throwable;
            }
        }
        stopWatch.stop();
        LOGGER.info("Creating {} with name '{}' finished in {} seconds", new Object[]{this.getResourceType(), name, stopWatch.getTotalTimeMillis() / 1000L});
        return t;
    }

    @Override
    public T getOrCreate(K key) {
        T result = this.get(key);
        if (result != null) {
            return result;
        }
        return this.create(key);
    }

    abstract String getResourceName(K var1);

    abstract String getResourceType();

    abstract T internalGet(K var1);

    abstract T internalCreate(K var1);
}

