/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.resourcemanager.implementation.crud;

import com.azure.core.management.exception.ManagementException;
import com.azure.resourcemanager.AzureResourceManager;
import com.azure.resourcemanager.redis.models.RedisCache;
import com.azure.spring.cloud.core.properties.resource.AzureResourceMetadata;
import com.azure.spring.cloud.resourcemanager.implementation.crud.AbstractResourceCrud;

public class RedisCacheCrud
extends AbstractResourceCrud<RedisCache, String> {
    public RedisCacheCrud(AzureResourceManager azureResourceManager, AzureResourceMetadata azureResourceMetadata) {
        super(azureResourceManager, azureResourceMetadata);
    }

    @Override
    String getResourceName(String key) {
        return key;
    }

    @Override
    String getResourceType() {
        return RedisCache.class.getSimpleName();
    }

    @Override
    public RedisCache internalGet(String name) {
        try {
            return (RedisCache)this.resourceManager.redisCaches().getByResourceGroup(this.resourceMetadata.getResourceGroup(), name);
        }
        catch (ManagementException e) {
            if (e.getResponse().getStatusCode() == 404) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public RedisCache internalCreate(String name) {
        return (RedisCache)((RedisCache.DefinitionStages.WithSku)((RedisCache.DefinitionStages.WithGroup)((RedisCache.DefinitionStages.Blank)this.resourceManager.redisCaches().define(name)).withRegion(this.resourceMetadata.getRegion())).withExistingResourceGroup(this.resourceMetadata.getResourceGroup())).withBasicSku().create();
    }
}

