/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.service.appconfiguration;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.util.Configuration;
import com.azure.data.appconfiguration.ConfigurationClientBuilder;
import com.azure.spring.core.credential.descriptor.AuthenticationDescriptor;
import com.azure.spring.core.credential.descriptor.TokenAuthenticationDescriptor;
import com.azure.spring.core.factory.AbstractAzureHttpClientBuilderFactory;
import com.azure.spring.core.properties.AzureProperties;
import com.azure.spring.core.properties.util.PropertyMapper;
import com.azure.spring.service.appconfiguration.AppConfigurationProperties;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;

public class ConfigurationClientBuilderFactory
extends AbstractAzureHttpClientBuilderFactory<ConfigurationClientBuilder> {
    private final AppConfigurationProperties appConfigurationProperties;

    public ConfigurationClientBuilderFactory(AppConfigurationProperties configurationProperties) {
        this.appConfigurationProperties = configurationProperties;
    }

    protected BiConsumer<ConfigurationClientBuilder, HttpClient> consumeHttpClient() {
        return ConfigurationClientBuilder::httpClient;
    }

    protected BiConsumer<ConfigurationClientBuilder, HttpPipelinePolicy> consumeHttpPipelinePolicy() {
        return ConfigurationClientBuilder::addPolicy;
    }

    protected BiConsumer<ConfigurationClientBuilder, HttpPipeline> consumeHttpPipeline() {
        return ConfigurationClientBuilder::pipeline;
    }

    protected BiConsumer<ConfigurationClientBuilder, HttpLogOptions> consumeHttpLogOptions() {
        return ConfigurationClientBuilder::httpLogOptions;
    }

    protected ConfigurationClientBuilder createBuilderInstance() {
        return new ConfigurationClientBuilder();
    }

    protected AzureProperties getAzureProperties() {
        return this.appConfigurationProperties;
    }

    protected List<AuthenticationDescriptor<?>> getAuthenticationDescriptors(ConfigurationClientBuilder builder) {
        return Arrays.asList(new TokenAuthenticationDescriptor(p -> builder.credential(p.getCredential())));
    }

    protected void configureService(ConfigurationClientBuilder builder) {
        PropertyMapper map = new PropertyMapper();
        map.from((Object)this.appConfigurationProperties.getEndpoint()).to(arg_0 -> ((ConfigurationClientBuilder)builder).endpoint(arg_0));
        map.from((Object)this.appConfigurationProperties.getConnectionString()).to(arg_0 -> ((ConfigurationClientBuilder)builder).connectionString(arg_0));
        map.from((Object)this.appConfigurationProperties.getServiceVersion()).to(arg_0 -> ((ConfigurationClientBuilder)builder).serviceVersion(arg_0));
    }

    protected BiConsumer<ConfigurationClientBuilder, Configuration> consumeConfiguration() {
        return ConfigurationClientBuilder::configuration;
    }

    protected BiConsumer<ConfigurationClientBuilder, TokenCredential> consumeDefaultTokenCredential() {
        return ConfigurationClientBuilder::credential;
    }

    protected BiConsumer<ConfigurationClientBuilder, String> consumeConnectionString() {
        return ConfigurationClientBuilder::connectionString;
    }

    protected BiConsumer<ConfigurationClientBuilder, RetryPolicy> consumeRetryPolicy() {
        return ConfigurationClientBuilder::retryPolicy;
    }
}

