/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.service.cosmos;

import com.azure.core.credential.TokenCredential;
import com.azure.core.util.Configuration;
import com.azure.cosmos.ConnectionMode;
import com.azure.cosmos.CosmosClientBuilder;
import com.azure.spring.core.credential.descriptor.AuthenticationDescriptor;
import com.azure.spring.core.credential.descriptor.KeyAuthenticationDescriptor;
import com.azure.spring.core.credential.descriptor.TokenAuthenticationDescriptor;
import com.azure.spring.core.factory.AbstractAzureServiceClientBuilderFactory;
import com.azure.spring.core.properties.AzureProperties;
import com.azure.spring.core.properties.util.PropertyMapper;
import com.azure.spring.service.cosmos.CosmosProperties;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CosmosClientBuilderFactory
extends AbstractAzureServiceClientBuilderFactory<CosmosClientBuilder> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CosmosClientBuilderFactory.class);
    private final CosmosProperties cosmosProperties;

    public CosmosClientBuilderFactory(CosmosProperties cosmosProperties) {
        this.cosmosProperties = cosmosProperties;
    }

    protected CosmosClientBuilder createBuilderInstance() {
        return new CosmosClientBuilder();
    }

    protected AzureProperties getAzureProperties() {
        return this.cosmosProperties;
    }

    protected List<AuthenticationDescriptor<?>> getAuthenticationDescriptors(CosmosClientBuilder builder) {
        return Arrays.asList(new KeyAuthenticationDescriptor(provider -> builder.credential(provider.getCredential())), new TokenAuthenticationDescriptor(provider -> builder.credential(provider.getCredential())));
    }

    protected void configureProxy(CosmosClientBuilder builder) {
        LOGGER.debug("No configureProxy for CosmosClientBuilder.");
    }

    protected void configureRetry(CosmosClientBuilder builder) {
        LOGGER.debug("No configureRetry for CosmosClientBuilder.");
    }

    protected void configureService(CosmosClientBuilder builder) {
        PropertyMapper map = new PropertyMapper();
        map.from((Object)this.cosmosProperties.getEndpoint()).to(arg_0 -> ((CosmosClientBuilder)builder).endpoint(arg_0));
        map.from((Object)this.cosmosProperties.getConsistencyLevel()).to(arg_0 -> ((CosmosClientBuilder)builder).consistencyLevel(arg_0));
        map.from((Object)this.cosmosProperties.getClientTelemetryEnabled()).to(arg_0 -> ((CosmosClientBuilder)builder).clientTelemetryEnabled(arg_0));
        map.from((Object)this.cosmosProperties.getConnectionSharingAcrossClientsEnabled()).to(arg_0 -> ((CosmosClientBuilder)builder).connectionSharingAcrossClientsEnabled(arg_0));
        map.from((Object)this.cosmosProperties.getContentResponseOnWriteEnabled()).to(arg_0 -> ((CosmosClientBuilder)builder).contentResponseOnWriteEnabled(arg_0));
        map.from((Object)this.cosmosProperties.getEndpointDiscoveryEnabled()).to(arg_0 -> ((CosmosClientBuilder)builder).endpointDiscoveryEnabled(arg_0));
        map.from((Object)this.cosmosProperties.getMultipleWriteRegionsEnabled()).to(arg_0 -> ((CosmosClientBuilder)builder).multipleWriteRegionsEnabled(arg_0));
        map.from((Object)this.cosmosProperties.getReadRequestsFallbackEnabled()).to(arg_0 -> ((CosmosClientBuilder)builder).readRequestsFallbackEnabled(arg_0));
        map.from((Object)this.cosmosProperties.getSessionCapturingOverrideEnabled()).to(arg_0 -> ((CosmosClientBuilder)builder).sessionCapturingOverrideEnabled(arg_0));
        map.from(this.cosmosProperties.getPreferredRegions()).whenNot(List::isEmpty).to(arg_0 -> ((CosmosClientBuilder)builder).preferredRegions(arg_0));
        map.from((Object)this.cosmosProperties.getThrottlingRetryOptions()).to(arg_0 -> ((CosmosClientBuilder)builder).throttlingRetryOptions(arg_0));
        map.from((Object)this.cosmosProperties.getResourceToken()).to(arg_0 -> ((CosmosClientBuilder)builder).resourceToken(arg_0));
        map.from(this.cosmosProperties.getPermissions()).whenNot(List::isEmpty).to(arg_0 -> ((CosmosClientBuilder)builder).permissions(arg_0));
        if (ConnectionMode.DIRECT.equals((Object)this.cosmosProperties.getConnectionMode())) {
            builder.directMode(this.cosmosProperties.getDirectConnection(), this.cosmosProperties.getGatewayConnection());
        } else if (ConnectionMode.GATEWAY.equals((Object)this.cosmosProperties.getConnectionMode())) {
            builder.gatewayMode(this.cosmosProperties.getGatewayConnection());
        }
    }

    protected BiConsumer<CosmosClientBuilder, String> consumeApplicationId() {
        return CosmosClientBuilder::userAgentSuffix;
    }

    protected BiConsumer<CosmosClientBuilder, Configuration> consumeConfiguration() {
        LOGGER.warn("Configuration instance is not supported to configure in CosmosClientBuilder");
        return (a, b) -> {};
    }

    protected BiConsumer<CosmosClientBuilder, TokenCredential> consumeDefaultTokenCredential() {
        return CosmosClientBuilder::credential;
    }

    protected BiConsumer<CosmosClientBuilder, String> consumeConnectionString() {
        LOGGER.debug("Connection string is not supported to configure in CosmosClientBuilder");
        return (a, b) -> {};
    }
}

