/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.service.eventhubs.factory;

import com.azure.core.amqp.AmqpRetryOptions;
import com.azure.core.amqp.AmqpTransportType;
import com.azure.core.amqp.ProxyOptions;
import com.azure.core.credential.TokenCredential;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.messaging.eventhubs.EventHubClientBuilder;
import com.azure.spring.core.credential.descriptor.AuthenticationDescriptor;
import com.azure.spring.core.credential.descriptor.NamedKeyAuthenticationDescriptor;
import com.azure.spring.core.credential.descriptor.SasAuthenticationDescriptor;
import com.azure.spring.core.credential.descriptor.TokenAuthenticationDescriptor;
import com.azure.spring.core.factory.AbstractAzureAmqpClientBuilderFactory;
import com.azure.spring.core.properties.AzureProperties;
import com.azure.spring.core.properties.util.PropertyMapper;
import com.azure.spring.service.eventhubs.properties.EventHubsCommonDescriptor;
import com.azure.spring.service.eventhubs.properties.EventHubsConsumerDescriptor;
import com.azure.spring.service.eventhubs.properties.EventHubsNamespaceDescriptor;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;

public class EventHubClientBuilderFactory
extends AbstractAzureAmqpClientBuilderFactory<EventHubClientBuilder> {
    private final EventHubsCommonDescriptor eventHubsProperties;

    public EventHubClientBuilderFactory(EventHubsCommonDescriptor eventHubsProperties) {
        this.eventHubsProperties = eventHubsProperties;
    }

    protected BiConsumer<EventHubClientBuilder, ProxyOptions> consumeProxyOptions() {
        return EventHubClientBuilder::proxyOptions;
    }

    protected BiConsumer<EventHubClientBuilder, AmqpTransportType> consumeAmqpTransportType() {
        return EventHubClientBuilder::transportType;
    }

    protected BiConsumer<EventHubClientBuilder, AmqpRetryOptions> consumeAmqpRetryOptions() {
        return EventHubClientBuilder::retry;
    }

    protected BiConsumer<EventHubClientBuilder, ClientOptions> consumeClientOptions() {
        return EventHubClientBuilder::clientOptions;
    }

    protected BiConsumer<EventHubClientBuilder, Configuration> consumeConfiguration() {
        return EventHubClientBuilder::configuration;
    }

    protected BiConsumer<EventHubClientBuilder, TokenCredential> consumeDefaultTokenCredential() {
        return (builder, tokenCredential) -> builder.credential(this.eventHubsProperties.getFQDN(), this.eventHubsProperties.getEventHubName(), tokenCredential);
    }

    protected BiConsumer<EventHubClientBuilder, String> consumeConnectionString() {
        return (builder, connectionString) -> builder.connectionString(connectionString, this.eventHubsProperties.getEventHubName());
    }

    protected EventHubClientBuilder createBuilderInstance() {
        return new EventHubClientBuilder();
    }

    protected AzureProperties getAzureProperties() {
        return this.eventHubsProperties;
    }

    protected void configureService(EventHubClientBuilder builder) {
        PropertyMapper mapper = new PropertyMapper();
        mapper.from((Object)this.eventHubsProperties.getCustomEndpointAddress()).to(arg_0 -> ((EventHubClientBuilder)builder).customEndpointAddress(arg_0));
        if (this.eventHubsProperties instanceof EventHubsNamespaceDescriptor) {
            mapper.from((Object)((EventHubsNamespaceDescriptor)this.eventHubsProperties).getSharedConnection()).whenTrue().to(t -> builder.shareConnection());
        }
        if (this.eventHubsProperties instanceof EventHubsConsumerDescriptor) {
            EventHubsConsumerDescriptor consumerProperties = (EventHubsConsumerDescriptor)this.eventHubsProperties;
            mapper.from((Object)consumerProperties.getConsumerGroup()).to(arg_0 -> ((EventHubClientBuilder)builder).consumerGroup(arg_0));
            mapper.from((Object)consumerProperties.getPrefetchCount()).to(arg_0 -> ((EventHubClientBuilder)builder).prefetchCount(arg_0));
        }
    }

    protected List<AuthenticationDescriptor<?>> getAuthenticationDescriptors(EventHubClientBuilder builder) {
        return Arrays.asList(new NamedKeyAuthenticationDescriptor(provider -> builder.credential(this.eventHubsProperties.getFQDN(), this.eventHubsProperties.getEventHubName(), provider.getCredential())), new SasAuthenticationDescriptor(provider -> builder.credential(this.eventHubsProperties.getFQDN(), this.eventHubsProperties.getEventHubName(), provider.getCredential())), new TokenAuthenticationDescriptor(provider -> builder.credential(this.eventHubsProperties.getFQDN(), this.eventHubsProperties.getEventHubName(), provider.getCredential())));
    }
}

