/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.service.eventhubs.factory;

import com.azure.core.amqp.AmqpRetryOptions;
import com.azure.core.amqp.AmqpTransportType;
import com.azure.core.amqp.ProxyOptions;
import com.azure.core.credential.TokenCredential;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.messaging.eventhubs.CheckpointStore;
import com.azure.messaging.eventhubs.EventProcessorClientBuilder;
import com.azure.messaging.eventhubs.models.EventPosition;
import com.azure.spring.core.credential.descriptor.AuthenticationDescriptor;
import com.azure.spring.core.credential.descriptor.NamedKeyAuthenticationDescriptor;
import com.azure.spring.core.credential.descriptor.SasAuthenticationDescriptor;
import com.azure.spring.core.credential.descriptor.TokenAuthenticationDescriptor;
import com.azure.spring.core.factory.AbstractAzureAmqpClientBuilderFactory;
import com.azure.spring.core.properties.AzureProperties;
import com.azure.spring.core.properties.util.PropertyMapper;
import com.azure.spring.service.eventhubs.processor.BatchEventProcessingListener;
import com.azure.spring.service.eventhubs.processor.EventProcessingListener;
import com.azure.spring.service.eventhubs.processor.RecordEventProcessingListener;
import com.azure.spring.service.eventhubs.properties.EventHubsProcessorDescriptor;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class EventProcessorClientBuilderFactory
extends AbstractAzureAmqpClientBuilderFactory<EventProcessorClientBuilder> {
    private final EventHubsProcessorDescriptor processorProperties;
    private final CheckpointStore checkpointStore;
    private final EventProcessingListener processorListener;

    public EventProcessorClientBuilderFactory(EventHubsProcessorDescriptor processorProperties, CheckpointStore checkpointStore, EventProcessingListener listener) {
        this.processorProperties = processorProperties;
        this.checkpointStore = checkpointStore;
        this.processorListener = listener;
    }

    protected BiConsumer<EventProcessorClientBuilder, ProxyOptions> consumeProxyOptions() {
        return EventProcessorClientBuilder::proxyOptions;
    }

    protected BiConsumer<EventProcessorClientBuilder, AmqpTransportType> consumeAmqpTransportType() {
        return EventProcessorClientBuilder::transportType;
    }

    protected BiConsumer<EventProcessorClientBuilder, AmqpRetryOptions> consumeAmqpRetryOptions() {
        return EventProcessorClientBuilder::retry;
    }

    protected BiConsumer<EventProcessorClientBuilder, ClientOptions> consumeClientOptions() {
        return EventProcessorClientBuilder::clientOptions;
    }

    protected EventProcessorClientBuilder createBuilderInstance() {
        return new EventProcessorClientBuilder();
    }

    protected AzureProperties getAzureProperties() {
        return this.processorProperties;
    }

    protected void configureService(EventProcessorClientBuilder builder) {
        PropertyMapper map = new PropertyMapper();
        map.from((Object)this.processorProperties.getConsumerGroup()).to(arg_0 -> ((EventProcessorClientBuilder)builder).consumerGroup(arg_0));
        map.from((Object)this.processorProperties.getPrefetchCount()).to(arg_0 -> ((EventProcessorClientBuilder)builder).prefetchCount(arg_0));
        map.from((Object)this.processorProperties.getCustomEndpointAddress()).to(arg_0 -> ((EventProcessorClientBuilder)builder).customEndpointAddress(arg_0));
        map.from((Object)this.processorProperties.getTrackLastEnqueuedEventProperties()).to(arg_0 -> ((EventProcessorClientBuilder)builder).trackLastEnqueuedEventProperties(arg_0));
        map.from((Object)this.processorProperties.getPartitionOwnershipExpirationInterval()).to(arg_0 -> ((EventProcessorClientBuilder)builder).partitionOwnershipExpirationInterval(arg_0));
        map.from((Object)this.processorProperties.getLoadBalancing().getStrategy()).to(arg_0 -> ((EventProcessorClientBuilder)builder).loadBalancingStrategy(arg_0));
        map.from((Object)this.processorProperties.getLoadBalancing().getUpdateInterval()).to(arg_0 -> ((EventProcessorClientBuilder)builder).loadBalancingUpdateInterval(arg_0));
        map.from(this.processorProperties.getInitialPartitionEventPosition()).when(c -> !CollectionUtils.isEmpty((Map)c)).to(p -> {
            Map<String, EventPosition> positions = p.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((EventHubsProcessorDescriptor.StartPosition)((Object)((Object)((Object)e.getValue())))).toEventPosition()));
            builder.initialPartitionEventPosition(positions);
        });
        this.configureCheckpointStore(builder);
        this.configureProcessorListener(builder);
    }

    protected List<AuthenticationDescriptor<?>> getAuthenticationDescriptors(EventProcessorClientBuilder builder) {
        return Arrays.asList(new NamedKeyAuthenticationDescriptor(provider -> builder.credential(this.processorProperties.getFQDN(), this.processorProperties.getEventHubName(), provider.getCredential())), new SasAuthenticationDescriptor(provider -> builder.credential(this.processorProperties.getFQDN(), this.processorProperties.getEventHubName(), provider.getCredential())), new TokenAuthenticationDescriptor(provider -> builder.credential(this.processorProperties.getFQDN(), this.processorProperties.getEventHubName(), provider.getCredential())));
    }

    protected BiConsumer<EventProcessorClientBuilder, Configuration> consumeConfiguration() {
        return EventProcessorClientBuilder::configuration;
    }

    protected BiConsumer<EventProcessorClientBuilder, TokenCredential> consumeDefaultTokenCredential() {
        return (builder, tokenCredential) -> builder.credential(this.processorProperties.getFQDN(), this.processorProperties.getEventHubName(), tokenCredential);
    }

    protected BiConsumer<EventProcessorClientBuilder, String> consumeConnectionString() {
        return (builder, s) -> builder.connectionString(s, this.processorProperties.getEventHubName());
    }

    private void configureCheckpointStore(EventProcessorClientBuilder builder) {
        builder.checkpointStore(this.checkpointStore);
    }

    private void configureProcessorListener(EventProcessorClientBuilder builder) {
        EventHubsProcessorDescriptor.Batch batch = this.processorProperties.getBatch();
        if (this.processorListener instanceof BatchEventProcessingListener) {
            Assert.notNull((Object)batch.getMaxSize(), (String)"Batch max size must be provided");
            builder.processEventBatch(((BatchEventProcessingListener)this.processorListener)::onEventBatch, batch.getMaxSize().intValue(), batch.getMaxWaitTime());
        } else if (this.processorListener instanceof RecordEventProcessingListener) {
            builder.processEvent(((RecordEventProcessingListener)this.processorListener)::onEvent);
        }
        builder.processError((Consumer)this.processorListener.getErrorContextConsumer());
        builder.processPartitionClose((Consumer)this.processorListener.getCloseContextConsumer());
        builder.processPartitionInitialization((Consumer)this.processorListener.getInitializationContextConsumer());
    }
}

