/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.service.eventhubs.properties;

import com.azure.messaging.eventhubs.LoadBalancingStrategy;
import com.azure.messaging.eventhubs.models.EventPosition;
import com.azure.spring.service.eventhubs.properties.EventHubsConsumerDescriptor;
import java.time.Duration;
import java.util.Map;

public interface EventHubsProcessorDescriptor
extends EventHubsConsumerDescriptor {
    public Boolean getTrackLastEnqueuedEventProperties();

    public Map<String, StartPosition> getInitialPartitionEventPosition();

    public Duration getPartitionOwnershipExpirationInterval();

    public Batch getBatch();

    public LoadBalancing getLoadBalancing();

    public static enum StartPosition {
        EARLIEST,
        LATEST;


        public EventPosition toEventPosition() {
            if (EARLIEST.equals((Object)this)) {
                return EventPosition.earliest();
            }
            return EventPosition.latest();
        }
    }

    public static class Batch {
        private Duration maxWaitTime;
        private Integer maxSize;

        public Duration getMaxWaitTime() {
            return this.maxWaitTime;
        }

        public void setMaxWaitTime(Duration maxWaitTime) {
            this.maxWaitTime = maxWaitTime;
        }

        public Integer getMaxSize() {
            return this.maxSize;
        }

        public void setMaxSize(Integer maxSize) {
            this.maxSize = maxSize;
        }
    }

    public static class LoadBalancing {
        private Duration updateInterval;
        private LoadBalancingStrategy strategy = LoadBalancingStrategy.BALANCED;

        public Duration getUpdateInterval() {
            return this.updateInterval;
        }

        public void setUpdateInterval(Duration updateInterval) {
            this.updateInterval = updateInterval;
        }

        public LoadBalancingStrategy getStrategy() {
            return this.strategy;
        }

        public void setStrategy(LoadBalancingStrategy strategy) {
            this.strategy = strategy;
        }
    }
}

