/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.service.keyvault.certificates;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.util.Configuration;
import com.azure.security.keyvault.certificates.CertificateClientBuilder;
import com.azure.spring.core.credential.descriptor.AuthenticationDescriptor;
import com.azure.spring.core.credential.descriptor.TokenAuthenticationDescriptor;
import com.azure.spring.core.factory.AbstractAzureHttpClientBuilderFactory;
import com.azure.spring.core.properties.AzureProperties;
import com.azure.spring.core.properties.util.PropertyMapper;
import com.azure.spring.service.keyvault.certificates.KeyVaultCertificateProperties;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateClientBuilderFactory
extends AbstractAzureHttpClientBuilderFactory<CertificateClientBuilder> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CertificateClientBuilderFactory.class);
    private final KeyVaultCertificateProperties certificateProperties;

    public CertificateClientBuilderFactory(KeyVaultCertificateProperties certificateProperties) {
        this.certificateProperties = certificateProperties;
    }

    protected BiConsumer<CertificateClientBuilder, HttpClient> consumeHttpClient() {
        return CertificateClientBuilder::httpClient;
    }

    protected BiConsumer<CertificateClientBuilder, HttpPipelinePolicy> consumeHttpPipelinePolicy() {
        return CertificateClientBuilder::addPolicy;
    }

    protected BiConsumer<CertificateClientBuilder, HttpPipeline> consumeHttpPipeline() {
        return CertificateClientBuilder::pipeline;
    }

    protected BiConsumer<CertificateClientBuilder, HttpLogOptions> consumeHttpLogOptions() {
        return CertificateClientBuilder::httpLogOptions;
    }

    protected CertificateClientBuilder createBuilderInstance() {
        return new CertificateClientBuilder();
    }

    protected AzureProperties getAzureProperties() {
        return this.certificateProperties;
    }

    protected List<AuthenticationDescriptor<?>> getAuthenticationDescriptors(CertificateClientBuilder builder) {
        return Arrays.asList(new TokenAuthenticationDescriptor(provider -> builder.credential(provider.getCredential())));
    }

    protected void configureService(CertificateClientBuilder builder) {
        PropertyMapper map = new PropertyMapper();
        map.from((Object)this.certificateProperties.getEndpoint()).to(arg_0 -> ((CertificateClientBuilder)builder).vaultUrl(arg_0));
        map.from((Object)this.certificateProperties.getServiceVersion()).to(arg_0 -> ((CertificateClientBuilder)builder).serviceVersion(arg_0));
    }

    protected BiConsumer<CertificateClientBuilder, Configuration> consumeConfiguration() {
        return CertificateClientBuilder::configuration;
    }

    protected BiConsumer<CertificateClientBuilder, TokenCredential> consumeDefaultTokenCredential() {
        return CertificateClientBuilder::credential;
    }

    protected BiConsumer<CertificateClientBuilder, String> consumeConnectionString() {
        LOGGER.debug("Connection string is not supported to configure in CertificateClientBuilder");
        return (a, b) -> {};
    }

    protected BiConsumer<CertificateClientBuilder, RetryPolicy> consumeRetryPolicy() {
        return CertificateClientBuilder::retryPolicy;
    }
}

