/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.service.keyvault.secrets;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.util.Configuration;
import com.azure.security.keyvault.secrets.SecretClientBuilder;
import com.azure.spring.core.credential.descriptor.AuthenticationDescriptor;
import com.azure.spring.core.credential.descriptor.TokenAuthenticationDescriptor;
import com.azure.spring.core.factory.AbstractAzureHttpClientBuilderFactory;
import com.azure.spring.core.properties.AzureProperties;
import com.azure.spring.core.properties.util.PropertyMapper;
import com.azure.spring.service.keyvault.secrets.KeyVaultSecretProperties;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecretClientBuilderFactory
extends AbstractAzureHttpClientBuilderFactory<SecretClientBuilder> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecretClientBuilderFactory.class);
    private final KeyVaultSecretProperties secretProperties;

    public SecretClientBuilderFactory(KeyVaultSecretProperties keyVaultProperties) {
        this.secretProperties = keyVaultProperties;
    }

    protected BiConsumer<SecretClientBuilder, HttpClient> consumeHttpClient() {
        return SecretClientBuilder::httpClient;
    }

    protected BiConsumer<SecretClientBuilder, HttpPipelinePolicy> consumeHttpPipelinePolicy() {
        return SecretClientBuilder::addPolicy;
    }

    protected BiConsumer<SecretClientBuilder, HttpPipeline> consumeHttpPipeline() {
        return SecretClientBuilder::pipeline;
    }

    protected BiConsumer<SecretClientBuilder, HttpLogOptions> consumeHttpLogOptions() {
        return SecretClientBuilder::httpLogOptions;
    }

    protected SecretClientBuilder createBuilderInstance() {
        return new SecretClientBuilder();
    }

    protected AzureProperties getAzureProperties() {
        return this.secretProperties;
    }

    protected List<AuthenticationDescriptor<?>> getAuthenticationDescriptors(SecretClientBuilder builder) {
        return Collections.singletonList(new TokenAuthenticationDescriptor(provider -> builder.credential(provider.getCredential())));
    }

    protected void configureService(SecretClientBuilder builder) {
        PropertyMapper map = new PropertyMapper();
        map.from((Object)this.secretProperties.getEndpoint()).to(arg_0 -> ((SecretClientBuilder)builder).vaultUrl(arg_0));
        map.from((Object)this.secretProperties.getServiceVersion()).to(arg_0 -> ((SecretClientBuilder)builder).serviceVersion(arg_0));
    }

    protected BiConsumer<SecretClientBuilder, Configuration> consumeConfiguration() {
        return SecretClientBuilder::configuration;
    }

    protected BiConsumer<SecretClientBuilder, TokenCredential> consumeDefaultTokenCredential() {
        return SecretClientBuilder::credential;
    }

    protected BiConsumer<SecretClientBuilder, String> consumeConnectionString() {
        LOGGER.debug("Connection string is not supported to configure in SecretClientBuilder");
        return (a, b) -> {};
    }

    protected BiConsumer<SecretClientBuilder, RetryPolicy> consumeRetryPolicy() {
        return SecretClientBuilder::retryPolicy;
    }
}

