/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.service.servicebus.factory;

import com.azure.core.amqp.AmqpRetryOptions;
import com.azure.core.amqp.AmqpTransportType;
import com.azure.core.amqp.ProxyOptions;
import com.azure.core.credential.TokenCredential;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.messaging.servicebus.ServiceBusClientBuilder;
import com.azure.spring.core.credential.descriptor.AuthenticationDescriptor;
import com.azure.spring.core.credential.descriptor.NamedKeyAuthenticationDescriptor;
import com.azure.spring.core.credential.descriptor.SasAuthenticationDescriptor;
import com.azure.spring.core.credential.descriptor.TokenAuthenticationDescriptor;
import com.azure.spring.core.factory.AbstractAzureAmqpClientBuilderFactory;
import com.azure.spring.core.properties.AzureProperties;
import com.azure.spring.service.servicebus.properties.ServiceBusCommonDescriptor;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;

public abstract class AbstractServiceBusSubClientBuilderFactory<T, P extends ServiceBusCommonDescriptor>
extends AbstractAzureAmqpClientBuilderFactory<T> {
    protected final P properties;
    protected final ServiceBusClientBuilder serviceBusClientBuilder;
    protected final boolean shareServiceBusClientBuilder;

    public AbstractServiceBusSubClientBuilderFactory(P properties) {
        this(null, properties);
    }

    public AbstractServiceBusSubClientBuilderFactory(ServiceBusClientBuilder serviceBusClientBuilder, P properties) {
        this.properties = properties;
        if (serviceBusClientBuilder != null) {
            this.serviceBusClientBuilder = serviceBusClientBuilder;
            this.shareServiceBusClientBuilder = true;
        } else {
            this.serviceBusClientBuilder = new ServiceBusClientBuilder();
            this.shareServiceBusClientBuilder = false;
        }
    }

    protected BiConsumer<T, ProxyOptions> consumeProxyOptions() {
        return (builder, proxy) -> {
            if (!this.shareServiceBusClientBuilder) {
                this.serviceBusClientBuilder.proxyOptions(proxy);
            }
        };
    }

    protected BiConsumer<T, AmqpTransportType> consumeAmqpTransportType() {
        return (builder, t) -> {
            if (!this.shareServiceBusClientBuilder) {
                this.serviceBusClientBuilder.transportType(t);
            }
        };
    }

    protected BiConsumer<T, AmqpRetryOptions> consumeAmqpRetryOptions() {
        return (builder, retry) -> {
            if (!this.shareServiceBusClientBuilder) {
                this.serviceBusClientBuilder.retryOptions(retry);
            }
        };
    }

    protected BiConsumer<T, ClientOptions> consumeClientOptions() {
        return (builder, client) -> {
            if (!this.shareServiceBusClientBuilder) {
                this.serviceBusClientBuilder.clientOptions(client);
            }
        };
    }

    protected AzureProperties getAzureProperties() {
        return this.properties;
    }

    protected List<AuthenticationDescriptor<?>> getAuthenticationDescriptors(T builder) {
        return Arrays.asList(new NamedKeyAuthenticationDescriptor(provider -> {
            if (!this.shareServiceBusClientBuilder) {
                this.serviceBusClientBuilder.credential(this.properties.getFQDN(), provider.getCredential());
            }
        }), new SasAuthenticationDescriptor(provider -> {
            if (!this.shareServiceBusClientBuilder) {
                this.serviceBusClientBuilder.credential(this.properties.getFQDN(), provider.getCredential());
            }
        }), new TokenAuthenticationDescriptor(provider -> {
            if (!this.shareServiceBusClientBuilder) {
                this.serviceBusClientBuilder.credential(this.properties.getFQDN(), provider.getCredential());
            }
        }));
    }

    protected BiConsumer<T, Configuration> consumeConfiguration() {
        return (builder, configuration) -> {
            if (!this.shareServiceBusClientBuilder) {
                this.serviceBusClientBuilder.configuration(configuration);
            }
        };
    }

    protected BiConsumer<T, TokenCredential> consumeDefaultTokenCredential() {
        return (builder, credential) -> {
            if (!this.shareServiceBusClientBuilder) {
                this.serviceBusClientBuilder.credential(this.properties.getFQDN(), credential);
            }
        };
    }

    protected BiConsumer<T, String> consumeConnectionString() {
        return (builder, connectionString) -> {
            if (!this.shareServiceBusClientBuilder) {
                this.serviceBusClientBuilder.connectionString(connectionString);
            }
        };
    }
}

