/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.service.servicebus.factory;

import com.azure.messaging.servicebus.ServiceBusClientBuilder;
import com.azure.spring.core.properties.util.PropertyMapper;
import com.azure.spring.service.servicebus.factory.AbstractServiceBusSubClientBuilderFactory;
import com.azure.spring.service.servicebus.properties.ServiceBusEntityType;
import com.azure.spring.service.servicebus.properties.ServiceBusProducerDescriptor;
import org.springframework.util.Assert;

public class ServiceBusSenderClientBuilderFactory
extends AbstractServiceBusSubClientBuilderFactory<ServiceBusClientBuilder.ServiceBusSenderClientBuilder, ServiceBusProducerDescriptor> {
    private final ServiceBusProducerDescriptor producerProperties;

    public ServiceBusSenderClientBuilderFactory(ServiceBusProducerDescriptor producerProperties) {
        this((ServiceBusClientBuilder)null, producerProperties);
    }

    public ServiceBusSenderClientBuilderFactory(ServiceBusClientBuilder serviceBusClientBuilder, ServiceBusProducerDescriptor producerProperties) {
        super(serviceBusClientBuilder, producerProperties);
        this.producerProperties = producerProperties;
    }

    protected ServiceBusClientBuilder.ServiceBusSenderClientBuilder createBuilderInstance() {
        return this.serviceBusClientBuilder.sender();
    }

    protected void configureService(ServiceBusClientBuilder.ServiceBusSenderClientBuilder builder) {
        Assert.notNull((Object)((Object)this.producerProperties.getEntityType()), (String)"Entity type cannot be null.");
        Assert.notNull((Object)this.producerProperties.getEntityName(), (String)"Entity name cannot be null.");
        PropertyMapper propertyMapper = new PropertyMapper();
        if (ServiceBusEntityType.QUEUE == this.producerProperties.getEntityType()) {
            propertyMapper.from((Object)this.producerProperties.getEntityName()).to(arg_0 -> ((ServiceBusClientBuilder.ServiceBusSenderClientBuilder)builder).queueName(arg_0));
        } else if (ServiceBusEntityType.TOPIC == this.producerProperties.getEntityType()) {
            propertyMapper.from((Object)this.producerProperties.getEntityName()).to(arg_0 -> ((ServiceBusClientBuilder.ServiceBusSenderClientBuilder)builder).topicName(arg_0));
        }
    }
}

