/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.service.servicebus.factory;

import com.azure.messaging.servicebus.ServiceBusClientBuilder;
import com.azure.spring.core.properties.util.PropertyMapper;
import com.azure.spring.service.servicebus.factory.AbstractServiceBusSubClientBuilderFactory;
import com.azure.spring.service.servicebus.processor.MessageProcessingListener;
import com.azure.spring.service.servicebus.processor.RecordMessageProcessingListener;
import com.azure.spring.service.servicebus.properties.ServiceBusEntityType;
import com.azure.spring.service.servicebus.properties.ServiceBusProcessorDescriptor;
import java.util.function.Consumer;
import org.springframework.util.Assert;

public class ServiceBusSessionProcessorClientBuilderFactory
extends AbstractServiceBusSubClientBuilderFactory<ServiceBusClientBuilder.ServiceBusSessionProcessorClientBuilder, ServiceBusProcessorDescriptor> {
    private final ServiceBusProcessorDescriptor processorDescriptor;
    private final MessageProcessingListener processingListener;

    public ServiceBusSessionProcessorClientBuilderFactory(ServiceBusProcessorDescriptor processorDescriptor, MessageProcessingListener processingListener) {
        this(null, processorDescriptor, processingListener);
    }

    public ServiceBusSessionProcessorClientBuilderFactory(ServiceBusClientBuilder serviceBusClientBuilder, ServiceBusProcessorDescriptor processorDescriptor, MessageProcessingListener processingListener) {
        super(serviceBusClientBuilder, processorDescriptor);
        this.processorDescriptor = processorDescriptor;
        this.processingListener = processingListener;
    }

    protected ServiceBusClientBuilder.ServiceBusSessionProcessorClientBuilder createBuilderInstance() {
        return this.serviceBusClientBuilder.sessionProcessor();
    }

    protected void configureService(ServiceBusClientBuilder.ServiceBusSessionProcessorClientBuilder builder) {
        Assert.notNull((Object)((Object)this.processorDescriptor.getEntityType()), (String)"Entity type cannot be null.");
        Assert.notNull((Object)this.processorDescriptor.getEntityName(), (String)"Entity name cannot be null.");
        PropertyMapper propertyMapper = new PropertyMapper();
        if (ServiceBusEntityType.QUEUE == this.processorDescriptor.getEntityType()) {
            propertyMapper.from((Object)this.processorDescriptor.getEntityName()).to(arg_0 -> ((ServiceBusClientBuilder.ServiceBusSessionProcessorClientBuilder)builder).queueName(arg_0));
        } else if (ServiceBusEntityType.TOPIC == this.processorDescriptor.getEntityType()) {
            propertyMapper.from((Object)this.processorDescriptor.getEntityName()).to(arg_0 -> ((ServiceBusClientBuilder.ServiceBusSessionProcessorClientBuilder)builder).topicName(arg_0));
        }
        propertyMapper.from((Object)this.processorDescriptor.getSubscriptionName()).to(arg_0 -> ((ServiceBusClientBuilder.ServiceBusSessionProcessorClientBuilder)builder).subscriptionName(arg_0));
        propertyMapper.from((Object)this.processorDescriptor.getReceiveMode()).to(arg_0 -> ((ServiceBusClientBuilder.ServiceBusSessionProcessorClientBuilder)builder).receiveMode(arg_0));
        propertyMapper.from((Object)this.processorDescriptor.getSubQueue()).to(arg_0 -> ((ServiceBusClientBuilder.ServiceBusSessionProcessorClientBuilder)builder).subQueue(arg_0));
        propertyMapper.from((Object)this.processorDescriptor.getPrefetchCount()).to(arg_0 -> ((ServiceBusClientBuilder.ServiceBusSessionProcessorClientBuilder)builder).prefetchCount(arg_0));
        propertyMapper.from((Object)this.processorDescriptor.getMaxAutoLockRenewDuration()).to(arg_0 -> ((ServiceBusClientBuilder.ServiceBusSessionProcessorClientBuilder)builder).maxAutoLockRenewDuration(arg_0));
        propertyMapper.from((Object)this.processorDescriptor.getAutoComplete()).whenFalse().to(t -> builder.disableAutoComplete());
        propertyMapper.from((Object)this.processorDescriptor.getMaxConcurrentCalls()).to(arg_0 -> ((ServiceBusClientBuilder.ServiceBusSessionProcessorClientBuilder)builder).maxConcurrentCalls(arg_0));
        propertyMapper.from((Object)this.processorDescriptor.getMaxConcurrentSessions()).to(arg_0 -> ((ServiceBusClientBuilder.ServiceBusSessionProcessorClientBuilder)builder).maxConcurrentSessions(arg_0));
        this.configureProcessorListener(builder);
    }

    private void configureProcessorListener(ServiceBusClientBuilder.ServiceBusSessionProcessorClientBuilder builder) {
        if (!(this.processingListener instanceof RecordMessageProcessingListener)) {
            throw new IllegalArgumentException("A " + RecordMessageProcessingListener.class.getSimpleName() + " is required when configure record processor.");
        }
        builder.processMessage(((RecordMessageProcessingListener)this.processingListener)::onMessage);
        builder.processError((Consumer)this.processingListener.getErrorContextConsumer());
    }
}

