/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.service.servicebus.factory;

import com.azure.messaging.servicebus.ServiceBusClientBuilder;
import com.azure.spring.core.properties.util.PropertyMapper;
import com.azure.spring.service.servicebus.factory.AbstractServiceBusSubClientBuilderFactory;
import com.azure.spring.service.servicebus.properties.ServiceBusConsumerDescriptor;
import com.azure.spring.service.servicebus.properties.ServiceBusEntityType;
import org.springframework.util.Assert;

public class ServiceBusSessionReceiverClientBuilderFactory
extends AbstractServiceBusSubClientBuilderFactory<ServiceBusClientBuilder.ServiceBusSessionReceiverClientBuilder, ServiceBusConsumerDescriptor> {
    private final ServiceBusConsumerDescriptor consumerProperties;

    public ServiceBusSessionReceiverClientBuilderFactory(ServiceBusConsumerDescriptor consumerDescriptor) {
        this((ServiceBusClientBuilder)null, consumerDescriptor);
    }

    public ServiceBusSessionReceiverClientBuilderFactory(ServiceBusClientBuilder serviceBusClientBuilder, ServiceBusConsumerDescriptor consumerDescriptor) {
        super(serviceBusClientBuilder, consumerDescriptor);
        this.consumerProperties = consumerDescriptor;
    }

    protected ServiceBusClientBuilder.ServiceBusSessionReceiverClientBuilder createBuilderInstance() {
        return this.serviceBusClientBuilder.sessionReceiver();
    }

    protected void configureService(ServiceBusClientBuilder.ServiceBusSessionReceiverClientBuilder builder) {
        Assert.notNull((Object)((Object)this.consumerProperties.getEntityType()), (String)"Entity type cannot be null.");
        Assert.notNull((Object)this.consumerProperties.getEntityName(), (String)"Entity name cannot be null.");
        if (ServiceBusEntityType.TOPIC == this.consumerProperties.getEntityType()) {
            Assert.notNull((Object)this.consumerProperties.getSubscriptionName(), (String)"Subscription cannot be null.");
        }
        PropertyMapper propertyMapper = new PropertyMapper();
        if (ServiceBusEntityType.QUEUE == this.consumerProperties.getEntityType()) {
            propertyMapper.from((Object)this.consumerProperties.getEntityName()).to(arg_0 -> ((ServiceBusClientBuilder.ServiceBusSessionReceiverClientBuilder)builder).queueName(arg_0));
        } else if (ServiceBusEntityType.TOPIC == this.consumerProperties.getEntityType()) {
            propertyMapper.from((Object)this.consumerProperties.getEntityName()).to(arg_0 -> ((ServiceBusClientBuilder.ServiceBusSessionReceiverClientBuilder)builder).topicName(arg_0));
            propertyMapper.from((Object)this.consumerProperties.getSubscriptionName()).to(arg_0 -> ((ServiceBusClientBuilder.ServiceBusSessionReceiverClientBuilder)builder).subscriptionName(arg_0));
        }
        propertyMapper.from((Object)this.consumerProperties.getReceiveMode()).to(arg_0 -> ((ServiceBusClientBuilder.ServiceBusSessionReceiverClientBuilder)builder).receiveMode(arg_0));
        propertyMapper.from((Object)this.consumerProperties.getSubQueue()).to(arg_0 -> ((ServiceBusClientBuilder.ServiceBusSessionReceiverClientBuilder)builder).subQueue(arg_0));
        propertyMapper.from((Object)this.consumerProperties.getPrefetchCount()).to(arg_0 -> ((ServiceBusClientBuilder.ServiceBusSessionReceiverClientBuilder)builder).prefetchCount(arg_0));
        propertyMapper.from((Object)this.consumerProperties.getMaxAutoLockRenewDuration()).to(arg_0 -> ((ServiceBusClientBuilder.ServiceBusSessionReceiverClientBuilder)builder).maxAutoLockRenewDuration(arg_0));
        propertyMapper.from((Object)this.consumerProperties.getAutoComplete()).whenFalse().to(t -> builder.disableAutoComplete());
    }
}

