/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.service.storage.blob;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.util.Configuration;
import com.azure.spring.core.credential.descriptor.AuthenticationDescriptor;
import com.azure.spring.core.credential.descriptor.SasAuthenticationDescriptor;
import com.azure.spring.core.credential.descriptor.TokenAuthenticationDescriptor;
import com.azure.spring.core.properties.AzureProperties;
import com.azure.spring.core.properties.util.PropertyMapper;
import com.azure.spring.service.storage.blob.StorageBlobProperties;
import com.azure.spring.service.storage.common.AbstractAzureStorageClientBuilderFactory;
import com.azure.spring.service.storage.common.credential.StorageSharedKeyAuthenticationDescriptor;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.blob.models.CustomerProvidedKey;
import com.azure.storage.common.policy.RequestRetryOptions;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;

public class BlobServiceClientBuilderFactory
extends AbstractAzureStorageClientBuilderFactory<BlobServiceClientBuilder> {
    private final StorageBlobProperties blobProperties;

    public BlobServiceClientBuilderFactory(StorageBlobProperties blobProperties) {
        this.blobProperties = blobProperties;
    }

    public BlobServiceClientBuilder createBuilderInstance() {
        return new BlobServiceClientBuilder();
    }

    public void configureService(BlobServiceClientBuilder builder) {
        PropertyMapper map = new PropertyMapper();
        map.from((Object)this.blobProperties.getCustomerProvidedKey()).to(CustomerProvidedKey::new);
        map.from((Object)this.blobProperties.getEncryptionScope()).to(arg_0 -> ((BlobServiceClientBuilder)builder).encryptionScope(arg_0));
        map.from((Object)this.blobProperties.getEndpoint()).to(arg_0 -> ((BlobServiceClientBuilder)builder).endpoint(arg_0));
        map.from((Object)this.blobProperties.getServiceVersion()).to(arg_0 -> ((BlobServiceClientBuilder)builder).serviceVersion(arg_0));
    }

    protected BiConsumer<BlobServiceClientBuilder, HttpClient> consumeHttpClient() {
        return BlobServiceClientBuilder::httpClient;
    }

    protected BiConsumer<BlobServiceClientBuilder, HttpPipelinePolicy> consumeHttpPipelinePolicy() {
        return BlobServiceClientBuilder::addPolicy;
    }

    protected BiConsumer<BlobServiceClientBuilder, HttpPipeline> consumeHttpPipeline() {
        return BlobServiceClientBuilder::pipeline;
    }

    protected BiConsumer<BlobServiceClientBuilder, HttpLogOptions> consumeHttpLogOptions() {
        return BlobServiceClientBuilder::httpLogOptions;
    }

    protected BiConsumer<BlobServiceClientBuilder, Configuration> consumeConfiguration() {
        return BlobServiceClientBuilder::configuration;
    }

    protected BiConsumer<BlobServiceClientBuilder, TokenCredential> consumeDefaultTokenCredential() {
        return BlobServiceClientBuilder::credential;
    }

    protected BiConsumer<BlobServiceClientBuilder, String> consumeConnectionString() {
        return BlobServiceClientBuilder::connectionString;
    }

    protected AzureProperties getAzureProperties() {
        return this.blobProperties;
    }

    protected List<AuthenticationDescriptor<?>> getAuthenticationDescriptors(BlobServiceClientBuilder builder) {
        return Arrays.asList(new StorageSharedKeyAuthenticationDescriptor(provider -> builder.credential(provider.getCredential())), new SasAuthenticationDescriptor(provider -> builder.credential(provider.getCredential())), new TokenAuthenticationDescriptor(provider -> builder.credential(provider.getCredential())));
    }

    @Override
    protected BiConsumer<BlobServiceClientBuilder, RequestRetryOptions> consumeRequestRetryOptions() {
        return BlobServiceClientBuilder::retryOptions;
    }
}

