/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.service.storage.common;

import com.azure.core.http.policy.RetryPolicy;
import com.azure.spring.core.aware.RetryAware;
import com.azure.spring.core.factory.AbstractAzureHttpClientBuilderFactory;
import com.azure.spring.service.storage.common.AzureStorageRetryOptionsConverter;
import com.azure.spring.service.storage.common.StorageRetry;
import com.azure.storage.common.policy.RequestRetryOptions;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAzureStorageClientBuilderFactory<T>
extends AbstractAzureHttpClientBuilderFactory<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAzureStorageClientBuilderFactory.class);

    protected abstract BiConsumer<T, RequestRetryOptions> consumeRequestRetryOptions();

    protected void configureRetry(T builder) {
        RetryAware.Retry retry = this.getAzureProperties().getRetry();
        if (retry instanceof StorageRetry) {
            RequestRetryOptions requestRetryOptions = AzureStorageRetryOptionsConverter.STORAGE_RETRY_CONVERTER.convert((StorageRetry)retry);
            this.consumeRequestRetryOptions().accept(builder, requestRetryOptions);
        } else {
            LOGGER.warn("The retry in a storage client builder is of type {}", (Object)retry.getClass().getName());
        }
    }

    protected BiConsumer<T, RetryPolicy> consumeRetryPolicy() {
        return (a, b) -> {};
    }
}

