/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.service.storage.common;

import com.azure.spring.core.aware.RetryAware;
import com.azure.spring.service.storage.common.StorageRetry;
import com.azure.storage.common.policy.RequestRetryOptions;
import com.azure.storage.common.policy.RetryPolicyType;
import java.time.Duration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.lang.NonNull;

public final class AzureStorageRetryOptionsConverter
implements Converter<StorageRetry, RequestRetryOptions> {
    public static final AzureStorageRetryOptionsConverter STORAGE_RETRY_CONVERTER = new AzureStorageRetryOptionsConverter();

    public RequestRetryOptions convert(@NonNull StorageRetry storageRetry) {
        RetryPolicyType retryPolicyType = null;
        Duration delay = null;
        Duration maxDelay = null;
        RetryAware.Backoff backoff = storageRetry.getBackoff();
        if (backoff != null) {
            retryPolicyType = backoff.getMultiplier() != null && backoff.getMultiplier() > 0.0 ? RetryPolicyType.EXPONENTIAL : RetryPolicyType.FIXED;
            delay = backoff.getDelay();
            maxDelay = backoff.getMaxDelay();
        }
        return new RequestRetryOptions(retryPolicyType, storageRetry.getMaxAttempts(), storageRetry.getTimeout(), delay, maxDelay, storageRetry.getSecondaryHost());
    }
}

