/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.service.storage.common.credential;

import com.azure.spring.core.credential.resolver.AzureCredentialResolver;
import com.azure.spring.core.properties.AzureProperties;
import com.azure.spring.service.storage.common.StorageProperties;
import com.azure.spring.service.storage.common.credential.StorageSharedKeyCredentialProvider;
import org.springframework.util.StringUtils;

public class StorageSharedKeyCredentialResolver
implements AzureCredentialResolver<StorageSharedKeyCredentialProvider> {
    public StorageSharedKeyCredentialProvider resolve(AzureProperties azureProperties) {
        if (!this.isResolvable(azureProperties)) {
            return null;
        }
        StorageProperties properties = (StorageProperties)azureProperties;
        if (azureProperties == null || !StringUtils.hasText((String)properties.getAccountName()) || !StringUtils.hasText((String)properties.getAccountKey())) {
            return null;
        }
        return new StorageSharedKeyCredentialProvider(properties.getAccountName(), properties.getAccountKey());
    }

    public boolean isResolvable(AzureProperties azureProperties) {
        return azureProperties instanceof StorageProperties;
    }
}

