/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.service.storage.fileshare;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.util.Configuration;
import com.azure.spring.core.credential.descriptor.AuthenticationDescriptor;
import com.azure.spring.core.credential.descriptor.SasAuthenticationDescriptor;
import com.azure.spring.core.properties.AzureProperties;
import com.azure.spring.core.properties.util.PropertyMapper;
import com.azure.spring.service.storage.common.AbstractAzureStorageClientBuilderFactory;
import com.azure.spring.service.storage.common.credential.StorageSharedKeyAuthenticationDescriptor;
import com.azure.spring.service.storage.fileshare.StorageFileShareProperties;
import com.azure.storage.common.policy.RequestRetryOptions;
import com.azure.storage.file.share.ShareServiceClientBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShareServiceClientBuilderFactory
extends AbstractAzureStorageClientBuilderFactory<ShareServiceClientBuilder> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShareServiceClientBuilderFactory.class);
    private final StorageFileShareProperties fileShareProperties;

    public ShareServiceClientBuilderFactory(StorageFileShareProperties fileShareProperties) {
        this.fileShareProperties = fileShareProperties;
    }

    protected BiConsumer<ShareServiceClientBuilder, HttpClient> consumeHttpClient() {
        return ShareServiceClientBuilder::httpClient;
    }

    protected BiConsumer<ShareServiceClientBuilder, HttpPipelinePolicy> consumeHttpPipelinePolicy() {
        return ShareServiceClientBuilder::addPolicy;
    }

    protected BiConsumer<ShareServiceClientBuilder, HttpPipeline> consumeHttpPipeline() {
        return ShareServiceClientBuilder::pipeline;
    }

    protected BiConsumer<ShareServiceClientBuilder, HttpLogOptions> consumeHttpLogOptions() {
        return ShareServiceClientBuilder::httpLogOptions;
    }

    protected ShareServiceClientBuilder createBuilderInstance() {
        return new ShareServiceClientBuilder();
    }

    protected AzureProperties getAzureProperties() {
        return this.fileShareProperties;
    }

    protected List<AuthenticationDescriptor<?>> getAuthenticationDescriptors(ShareServiceClientBuilder builder) {
        return Arrays.asList(new StorageSharedKeyAuthenticationDescriptor(provider -> builder.credential(provider.getCredential())), new SasAuthenticationDescriptor(provider -> builder.credential(provider.getCredential())));
    }

    protected void configureService(ShareServiceClientBuilder builder) {
        PropertyMapper map = new PropertyMapper();
        map.from((Object)this.fileShareProperties.getEndpoint()).to(arg_0 -> ((ShareServiceClientBuilder)builder).endpoint(arg_0));
        map.from((Object)this.fileShareProperties.getServiceVersion()).to(arg_0 -> ((ShareServiceClientBuilder)builder).serviceVersion(arg_0));
    }

    protected BiConsumer<ShareServiceClientBuilder, Configuration> consumeConfiguration() {
        return ShareServiceClientBuilder::configuration;
    }

    protected BiConsumer<ShareServiceClientBuilder, TokenCredential> consumeDefaultTokenCredential() {
        LOGGER.warn("TokenCredential is not supported to configure in ShareServiceClientBuilder.");
        return (a, b) -> {};
    }

    protected BiConsumer<ShareServiceClientBuilder, String> consumeConnectionString() {
        return ShareServiceClientBuilder::connectionString;
    }

    @Override
    protected BiConsumer<ShareServiceClientBuilder, RequestRetryOptions> consumeRequestRetryOptions() {
        return ShareServiceClientBuilder::retryOptions;
    }
}

