/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.service.storage.queue;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.util.Configuration;
import com.azure.spring.core.credential.descriptor.AuthenticationDescriptor;
import com.azure.spring.core.credential.descriptor.SasAuthenticationDescriptor;
import com.azure.spring.core.credential.descriptor.TokenAuthenticationDescriptor;
import com.azure.spring.core.properties.AzureProperties;
import com.azure.spring.core.properties.util.PropertyMapper;
import com.azure.spring.service.storage.common.AbstractAzureStorageClientBuilderFactory;
import com.azure.spring.service.storage.common.credential.StorageSharedKeyAuthenticationDescriptor;
import com.azure.spring.service.storage.queue.StorageQueueProperties;
import com.azure.storage.common.policy.RequestRetryOptions;
import com.azure.storage.queue.QueueMessageEncoding;
import com.azure.storage.queue.QueueServiceClientBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;

public class QueueServiceClientBuilderFactory
extends AbstractAzureStorageClientBuilderFactory<QueueServiceClientBuilder> {
    private final StorageQueueProperties queueProperties;

    public QueueServiceClientBuilderFactory(StorageQueueProperties queueProperties) {
        this.queueProperties = queueProperties;
    }

    protected BiConsumer<QueueServiceClientBuilder, HttpClient> consumeHttpClient() {
        return QueueServiceClientBuilder::httpClient;
    }

    protected BiConsumer<QueueServiceClientBuilder, HttpPipelinePolicy> consumeHttpPipelinePolicy() {
        return QueueServiceClientBuilder::addPolicy;
    }

    protected BiConsumer<QueueServiceClientBuilder, HttpPipeline> consumeHttpPipeline() {
        return QueueServiceClientBuilder::pipeline;
    }

    protected BiConsumer<QueueServiceClientBuilder, HttpLogOptions> consumeHttpLogOptions() {
        return QueueServiceClientBuilder::httpLogOptions;
    }

    protected QueueServiceClientBuilder createBuilderInstance() {
        return new QueueServiceClientBuilder();
    }

    protected AzureProperties getAzureProperties() {
        return this.queueProperties;
    }

    protected List<AuthenticationDescriptor<?>> getAuthenticationDescriptors(QueueServiceClientBuilder builder) {
        return Arrays.asList(new StorageSharedKeyAuthenticationDescriptor(provider -> builder.credential(provider.getCredential())), new SasAuthenticationDescriptor(provider -> builder.credential(provider.getCredential())), new TokenAuthenticationDescriptor(provider -> builder.credential(provider.getCredential())));
    }

    protected void configureService(QueueServiceClientBuilder builder) {
        PropertyMapper map = new PropertyMapper();
        map.from((Object)this.queueProperties.getMessageEncoding()).to(p -> builder.messageEncoding(this.convertToMessageEncoding((String)p)));
        map.from((Object)this.queueProperties.getServiceVersion()).to(arg_0 -> ((QueueServiceClientBuilder)builder).serviceVersion(arg_0));
        map.from((Object)this.queueProperties.getEndpoint()).to(arg_0 -> ((QueueServiceClientBuilder)builder).endpoint(arg_0));
    }

    protected BiConsumer<QueueServiceClientBuilder, Configuration> consumeConfiguration() {
        return QueueServiceClientBuilder::configuration;
    }

    protected BiConsumer<QueueServiceClientBuilder, TokenCredential> consumeDefaultTokenCredential() {
        return QueueServiceClientBuilder::credential;
    }

    protected BiConsumer<QueueServiceClientBuilder, String> consumeConnectionString() {
        return QueueServiceClientBuilder::connectionString;
    }

    private QueueMessageEncoding convertToMessageEncoding(String messageEncoding) {
        return QueueMessageEncoding.BASE64.name().equalsIgnoreCase(messageEncoding) ? QueueMessageEncoding.BASE64 : QueueMessageEncoding.NONE;
    }

    @Override
    protected BiConsumer<QueueServiceClientBuilder, RequestRetryOptions> consumeRequestRetryOptions() {
        return QueueServiceClientBuilder::retryOptions;
    }
}

