/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.service.implementation.storage.blob;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.spring.cloud.core.implementation.credential.descriptor.AuthenticationDescriptor;
import com.azure.spring.cloud.core.implementation.credential.descriptor.SasAuthenticationDescriptor;
import com.azure.spring.cloud.core.implementation.credential.descriptor.TokenAuthenticationDescriptor;
import com.azure.spring.cloud.core.implementation.properties.PropertyMapper;
import com.azure.spring.cloud.core.properties.AzureProperties;
import com.azure.spring.cloud.service.implementation.storage.blob.BlobServiceClientProperties;
import com.azure.spring.cloud.service.implementation.storage.common.AbstractAzureStorageClientBuilderFactory;
import com.azure.spring.cloud.service.implementation.storage.common.credential.StorageSharedKeyAuthenticationDescriptor;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.blob.models.CustomerProvidedKey;
import com.azure.storage.common.policy.RequestRetryOptions;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;

public class BlobServiceClientBuilderFactory
extends AbstractAzureStorageClientBuilderFactory<BlobServiceClientBuilder> {
    private final BlobServiceClientProperties blobServiceClientProperties;

    public BlobServiceClientBuilderFactory(BlobServiceClientProperties blobServiceClientProperties) {
        this.blobServiceClientProperties = blobServiceClientProperties;
    }

    protected BiConsumer<BlobServiceClientBuilder, ClientOptions> consumeClientOptions() {
        return BlobServiceClientBuilder::clientOptions;
    }

    public BlobServiceClientBuilder createBuilderInstance() {
        return new BlobServiceClientBuilder();
    }

    public void configureService(BlobServiceClientBuilder builder) {
        PropertyMapper map = new PropertyMapper();
        map.from((Object)this.blobServiceClientProperties.getCustomerProvidedKey()).to(CustomerProvidedKey::new);
        map.from((Object)this.blobServiceClientProperties.getEncryptionScope()).to(arg_0 -> ((BlobServiceClientBuilder)builder).encryptionScope(arg_0));
        map.from((Object)this.blobServiceClientProperties.getEndpoint()).to(arg_0 -> ((BlobServiceClientBuilder)builder).endpoint(arg_0));
        map.from((Object)this.blobServiceClientProperties.getServiceVersion()).to(arg_0 -> ((BlobServiceClientBuilder)builder).serviceVersion(arg_0));
    }

    protected BiConsumer<BlobServiceClientBuilder, HttpClient> consumeHttpClient() {
        return BlobServiceClientBuilder::httpClient;
    }

    protected BiConsumer<BlobServiceClientBuilder, HttpPipelinePolicy> consumeHttpPipelinePolicy() {
        return BlobServiceClientBuilder::addPolicy;
    }

    protected BiConsumer<BlobServiceClientBuilder, HttpPipeline> consumeHttpPipeline() {
        return BlobServiceClientBuilder::pipeline;
    }

    protected BiConsumer<BlobServiceClientBuilder, HttpLogOptions> consumeHttpLogOptions() {
        return BlobServiceClientBuilder::httpLogOptions;
    }

    protected BiConsumer<BlobServiceClientBuilder, Configuration> consumeConfiguration() {
        return BlobServiceClientBuilder::configuration;
    }

    protected BiConsumer<BlobServiceClientBuilder, TokenCredential> consumeDefaultTokenCredential() {
        return BlobServiceClientBuilder::credential;
    }

    protected BiConsumer<BlobServiceClientBuilder, String> consumeConnectionString() {
        return BlobServiceClientBuilder::connectionString;
    }

    protected AzureProperties getAzureProperties() {
        return this.blobServiceClientProperties;
    }

    protected List<AuthenticationDescriptor<?>> getAuthenticationDescriptors(BlobServiceClientBuilder builder) {
        AuthenticationDescriptor[] authenticationDescriptorArray = new AuthenticationDescriptor[3];
        authenticationDescriptorArray[0] = new StorageSharedKeyAuthenticationDescriptor(arg_0 -> ((BlobServiceClientBuilder)builder).credential(arg_0));
        authenticationDescriptorArray[1] = new SasAuthenticationDescriptor(arg_0 -> ((BlobServiceClientBuilder)builder).credential(arg_0));
        authenticationDescriptorArray[2] = new TokenAuthenticationDescriptor(this.tokenCredentialResolver, arg_0 -> ((BlobServiceClientBuilder)builder).credential(arg_0));
        return Arrays.asList(authenticationDescriptorArray);
    }

    @Override
    protected BiConsumer<BlobServiceClientBuilder, RequestRetryOptions> consumeRequestRetryOptions() {
        return BlobServiceClientBuilder::retryOptions;
    }
}

