/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.service.implementation.kafka;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.identity.DefaultAzureCredentialBuilder;
import com.azure.spring.cloud.core.implementation.credential.resolver.AzureTokenCredentialResolver;
import com.azure.spring.cloud.core.implementation.factory.credential.DefaultAzureCredentialBuilderFactory;
import com.azure.spring.cloud.core.properties.AzureProperties;
import com.azure.spring.cloud.service.implementation.kafka.AzureKafkaProperties;
import com.azure.spring.cloud.service.implementation.kafka.AzureKafkaPropertiesUtils;
import com.azure.spring.cloud.service.implementation.kafka.AzureOAuthBearerToken;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerTokenCallback;

public class KafkaOAuth2AuthenticateCallbackHandler
implements AuthenticateCallbackHandler {
    private static final Duration ACCESS_TOKEN_REQUEST_BLOCK_TIME = Duration.ofSeconds(30L);
    private static final String TOKEN_AUDIENCE_FORMAT = "%s://%s/.default";
    private final AzureKafkaProperties properties;
    private final AzureTokenCredentialResolver tokenCredentialResolver;
    private TokenCredential credential;
    private AzureOAuthBearerToken accessToken;
    private String tokenAudience;

    public KafkaOAuth2AuthenticateCallbackHandler() {
        this(new AzureKafkaProperties(), new AzureTokenCredentialResolver());
    }

    public KafkaOAuth2AuthenticateCallbackHandler(AzureKafkaProperties properties, AzureTokenCredentialResolver tokenCredentialResolver) {
        this.properties = properties;
        this.tokenCredentialResolver = tokenCredentialResolver;
    }

    public void configure(Map<String, ?> configs, String mechanism, List<AppConfigurationEntry> jaasConfigEntries) {
        List bootstrapServers = (List)configs.get("bootstrap.servers");
        if (bootstrapServers == null || bootstrapServers.size() != 1) {
            throw new IllegalArgumentException("Invalid bootstrap servers configured for Azure Event Hubs for Kafka! Must supply exactly 1 non-null bootstrap server configuration, with the format as {YOUR.EVENTHUBS.FQDN}:9093.");
        }
        String bootstrapServer = (String)bootstrapServers.get(0);
        if (!bootstrapServer.endsWith(":9093")) {
            throw new IllegalArgumentException("Invalid bootstrap server configured for Azure Event Hubs for Kafka! The format should be {YOUR.EVENTHUBS.FQDN}:9093.");
        }
        URI uri = URI.create("https://" + bootstrapServer);
        this.tokenAudience = String.format(TOKEN_AUDIENCE_FORMAT, uri.getScheme(), uri.getHost());
        this.credential = (TokenCredential)configs.get("azure.token.credential");
        AzureKafkaPropertiesUtils.convertConfigMapToAzureProperties(configs, this.properties);
    }

    public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (!(callback instanceof OAuthBearerTokenCallback)) {
                throw new UnsupportedCallbackException(callback);
            }
            OAuthBearerTokenCallback oauthCallback = (OAuthBearerTokenCallback)callback;
            this.credential = this.getTokenCredential();
            OAuthBearerToken token = this.getOAuthBearerToken();
            oauthCallback.token(token);
        }
    }

    private TokenCredential getTokenCredential() {
        if (this.credential == null) {
            this.credential = this.tokenCredentialResolver.resolve((AzureProperties)this.properties);
            if (this.credential == null) {
                this.credential = ((DefaultAzureCredentialBuilder)new DefaultAzureCredentialBuilderFactory((AzureProperties)this.properties).build()).build();
            }
        }
        return this.credential;
    }

    private OAuthBearerToken getOAuthBearerToken() {
        if (this.accessToken == null || this.accessToken.isExpired()) {
            TokenRequestContext request = new TokenRequestContext();
            request.addScopes(new String[]{this.tokenAudience});
            request.setTenantId(this.properties.getProfile().getTenantId());
            AccessToken accessToken = (AccessToken)this.credential.getToken(request).block(ACCESS_TOKEN_REQUEST_BLOCK_TIME);
            if (accessToken != null) {
                this.accessToken = new AzureOAuthBearerToken(accessToken);
            }
        }
        return this.accessToken;
    }

    public void close() {
    }
}

