/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.service.implementation.kafka;

import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.identity.DefaultAzureCredentialBuilder;
import com.azure.spring.cloud.core.credential.AzureCredentialResolver;
import com.azure.spring.cloud.core.implementation.credential.resolver.AzureTokenCredentialResolver;
import com.azure.spring.cloud.core.implementation.factory.credential.DefaultAzureCredentialBuilderFactory;
import com.azure.spring.cloud.core.properties.AzureProperties;
import com.azure.spring.cloud.service.implementation.kafka.AzureKafkaProperties;
import com.azure.spring.cloud.service.implementation.kafka.AzureKafkaPropertiesUtils;
import com.azure.spring.cloud.service.implementation.kafka.AzureOAuthBearerToken;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerTokenCallback;
import reactor.core.publisher.Mono;

public class KafkaOAuth2AuthenticateCallbackHandler
implements AuthenticateCallbackHandler {
    private static final Duration ACCESS_TOKEN_REQUEST_BLOCK_TIME = Duration.ofSeconds(30L);
    private static final String TOKEN_AUDIENCE_FORMAT = "%s://%s/.default";
    private final AzureKafkaProperties properties;
    private final AzureCredentialResolver<TokenCredential> externalTokenCredentialResolver;
    private AzureCredentialResolver<TokenCredential> tokenCredentialResolver;
    private Function<TokenCredential, Mono<AzureOAuthBearerToken>> resolveToken;

    public KafkaOAuth2AuthenticateCallbackHandler() {
        this(null, null);
    }

    public KafkaOAuth2AuthenticateCallbackHandler(AzureKafkaProperties properties, AzureCredentialResolver<TokenCredential> externalTokenCredentialResolver) {
        this.properties = properties == null ? new AzureKafkaProperties() : properties;
        this.externalTokenCredentialResolver = externalTokenCredentialResolver == null ? new AzureTokenCredentialResolver() : externalTokenCredentialResolver;
    }

    public void configure(Map<String, ?> configs, String mechanism, List<AppConfigurationEntry> jaasConfigEntries) {
        AzureKafkaPropertiesUtils.convertConfigMapToAzureProperties(configs, this.properties);
        TokenRequestContext request = this.buildTokenRequestContext(configs);
        this.resolveToken = tokenCredential -> tokenCredential.getToken(request).map(AzureOAuthBearerToken::new);
        this.tokenCredentialResolver = new InternalCredentialResolver(this.externalTokenCredentialResolver, configs);
    }

    private TokenRequestContext buildTokenRequestContext(Map<String, ?> configs) {
        URI uri = this.buildEventHubsServerUri(configs);
        String tokenAudience = this.buildTokenAudience(uri);
        TokenRequestContext request = new TokenRequestContext();
        request.addScopes(new String[]{tokenAudience});
        request.setTenantId(this.properties.getProfile().getTenantId());
        return request;
    }

    private URI buildEventHubsServerUri(Map<String, ?> configs) {
        List bootstrapServers = (List)configs.get("bootstrap.servers");
        if (bootstrapServers == null || bootstrapServers.size() != 1) {
            throw new IllegalArgumentException("Invalid bootstrap servers configured for Azure Event Hubs for Kafka! Must supply exactly 1 non-null bootstrap server configuration, with the format as {YOUR.EVENTHUBS.FQDN}:9093.");
        }
        String bootstrapServer = (String)bootstrapServers.get(0);
        if (bootstrapServer == null || !bootstrapServer.endsWith(":9093")) {
            throw new IllegalArgumentException("Invalid bootstrap server configured for Azure Event Hubs for Kafka! The format should be {YOUR.EVENTHUBS.FQDN}:9093.");
        }
        URI uri = URI.create("https://" + bootstrapServer);
        return uri;
    }

    private String buildTokenAudience(URI uri) {
        return String.format(TOKEN_AUDIENCE_FORMAT, uri.getScheme(), uri.getHost());
    }

    public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (!(callback instanceof OAuthBearerTokenCallback)) {
                throw new UnsupportedCallbackException(callback);
            }
            OAuthBearerTokenCallback oauthCallback = (OAuthBearerTokenCallback)callback;
            this.resolveToken.apply((TokenCredential)this.tokenCredentialResolver.resolve((AzureProperties)this.properties)).doOnNext(arg_0 -> ((OAuthBearerTokenCallback)oauthCallback).token(arg_0)).doOnError(throwable -> oauthCallback.error("invalid_grant", throwable.getMessage(), null)).block(ACCESS_TOKEN_REQUEST_BLOCK_TIME);
        }
    }

    public void close() {
    }

    private static class InternalCredentialResolver
    implements AzureCredentialResolver<TokenCredential> {
        private final AzureCredentialResolver<TokenCredential> delegated;
        private final Map<String, ?> configs;
        private TokenCredential credential;

        InternalCredentialResolver(AzureCredentialResolver<TokenCredential> delegated, Map<String, ?> configs) {
            this.delegated = delegated;
            this.configs = configs;
        }

        public TokenCredential resolve(AzureProperties properties) {
            if (this.credential == null) {
                this.credential = (TokenCredential)this.configs.get("azure.token.credential");
                if (this.credential == null) {
                    this.credential = (TokenCredential)this.delegated.resolve(properties);
                    if (this.credential == null) {
                        this.credential = ((DefaultAzureCredentialBuilder)new DefaultAzureCredentialBuilderFactory(properties).build()).build();
                    }
                }
            }
            return this.credential;
        }

        public boolean isResolvable(AzureProperties properties) {
            return true;
        }
    }
}

