/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.service.implementation.storage;

import com.azure.spring.cloud.core.provider.RetryOptionsProvider;
import com.azure.spring.cloud.service.implementation.storage.common.StorageRetry;
import com.azure.storage.common.policy.RequestRetryOptions;
import com.azure.storage.common.policy.RetryPolicyType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.lang.NonNull;

public final class AzureStorageRetryOptionsConverter
implements Converter<StorageRetry, RequestRetryOptions> {
    public static final AzureStorageRetryOptionsConverter STORAGE_RETRY_CONVERTER = new AzureStorageRetryOptionsConverter();
    private static final Logger LOGGER = LoggerFactory.getLogger(AzureStorageRetryOptionsConverter.class);

    private AzureStorageRetryOptionsConverter() {
    }

    public RequestRetryOptions convert(@NonNull StorageRetry storageRetry) {
        RetryOptionsProvider.RetryMode retryMode = storageRetry.getMode();
        if (RetryOptionsProvider.RetryMode.EXPONENTIAL == retryMode) {
            RetryOptionsProvider.RetryOptions.ExponentialRetryOptions exponential = storageRetry.getExponential();
            if (exponential != null && exponential.getMaxRetries() != null) {
                return new RequestRetryOptions(RetryPolicyType.EXPONENTIAL, exponential.getMaxRetries(), storageRetry.getTryTimeout(), exponential.getBaseDelay(), exponential.getMaxDelay(), storageRetry.getSecondaryHost());
            }
            LOGGER.debug("The max-retries is not set, skip the convert.");
        } else if (RetryOptionsProvider.RetryMode.FIXED == retryMode) {
            RetryOptionsProvider.RetryOptions.FixedRetryOptions fixed = storageRetry.getFixed();
            if (fixed != null && fixed.getMaxRetries() != null) {
                return new RequestRetryOptions(RetryPolicyType.FIXED, fixed.getMaxRetries(), storageRetry.getTryTimeout(), fixed.getDelay(), fixed.getDelay(), storageRetry.getSecondaryHost());
            }
            LOGGER.debug("The max-retries is not set, skip the convert.");
        }
        return null;
    }
}

