/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.service.implementation.openai;

import com.azure.ai.openai.OpenAIClientBuilder;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.spring.cloud.core.implementation.credential.descriptor.AuthenticationDescriptor;
import com.azure.spring.cloud.core.implementation.credential.descriptor.KeyAuthenticationDescriptor;
import com.azure.spring.cloud.core.implementation.credential.descriptor.TokenAuthenticationDescriptor;
import com.azure.spring.cloud.core.implementation.factory.AbstractAzureHttpClientBuilderFactory;
import com.azure.spring.cloud.core.implementation.properties.PropertyMapper;
import com.azure.spring.cloud.core.properties.AzureProperties;
import com.azure.spring.cloud.service.implementation.openai.OpenAIClientProperties;
import com.azure.spring.cloud.service.implementation.openai.credential.NonAzureOpenAIKeyAuthenticationDescriptor;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAIClientBuilderFactory
extends AbstractAzureHttpClientBuilderFactory<OpenAIClientBuilder> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenAIClientBuilderFactory.class);
    private final OpenAIClientProperties openAIClientProperties;

    public OpenAIClientBuilderFactory(OpenAIClientProperties openAIClientProperties) {
        this.openAIClientProperties = openAIClientProperties;
    }

    protected BiConsumer<OpenAIClientBuilder, ClientOptions> consumeClientOptions() {
        return OpenAIClientBuilder::clientOptions;
    }

    protected BiConsumer<OpenAIClientBuilder, HttpClient> consumeHttpClient() {
        return OpenAIClientBuilder::httpClient;
    }

    protected BiConsumer<OpenAIClientBuilder, HttpPipelinePolicy> consumeHttpPipelinePolicy() {
        return OpenAIClientBuilder::addPolicy;
    }

    protected BiConsumer<OpenAIClientBuilder, HttpPipeline> consumeHttpPipeline() {
        return OpenAIClientBuilder::pipeline;
    }

    protected BiConsumer<OpenAIClientBuilder, HttpLogOptions> consumeHttpLogOptions() {
        return OpenAIClientBuilder::httpLogOptions;
    }

    protected BiConsumer<OpenAIClientBuilder, RetryPolicy> consumeRetryPolicy() {
        return OpenAIClientBuilder::retryPolicy;
    }

    protected OpenAIClientBuilder createBuilderInstance() {
        return new OpenAIClientBuilder();
    }

    protected AzureProperties getAzureProperties() {
        return this.openAIClientProperties;
    }

    protected List<AuthenticationDescriptor<?>> getAuthenticationDescriptors(OpenAIClientBuilder builder) {
        AuthenticationDescriptor[] authenticationDescriptorArray = new AuthenticationDescriptor[3];
        authenticationDescriptorArray[0] = new KeyAuthenticationDescriptor(arg_0 -> ((OpenAIClientBuilder)builder).credential(arg_0));
        authenticationDescriptorArray[1] = new NonAzureOpenAIKeyAuthenticationDescriptor(arg_0 -> ((OpenAIClientBuilder)builder).credential(arg_0));
        authenticationDescriptorArray[2] = new TokenAuthenticationDescriptor(this.tokenCredentialResolver, arg_0 -> ((OpenAIClientBuilder)builder).credential(arg_0));
        return Arrays.asList(authenticationDescriptorArray);
    }

    protected void configureService(OpenAIClientBuilder builder) {
        PropertyMapper map = new PropertyMapper();
        map.from((Object)this.openAIClientProperties.getEndpoint()).to(arg_0 -> ((OpenAIClientBuilder)builder).endpoint(arg_0));
        map.from((Object)this.openAIClientProperties.getServiceVersion()).to(arg_0 -> ((OpenAIClientBuilder)builder).serviceVersion(arg_0));
    }

    protected BiConsumer<OpenAIClientBuilder, Configuration> consumeConfiguration() {
        return OpenAIClientBuilder::configuration;
    }

    protected BiConsumer<OpenAIClientBuilder, TokenCredential> consumeDefaultTokenCredential() {
        return OpenAIClientBuilder::credential;
    }

    protected BiConsumer<OpenAIClientBuilder, String> consumeConnectionString() {
        LOGGER.debug("Connection string is not supported to configure in OpenAIClientBuilder");
        return (a, b) -> {};
    }
}

