/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.service.implementation.openai.credential;

import com.azure.ai.openai.models.NonAzureOpenAIKeyCredential;
import com.azure.spring.cloud.core.credential.AzureCredentialResolver;
import com.azure.spring.cloud.core.properties.AzureProperties;
import com.azure.spring.cloud.service.implementation.openai.OpenAIClientProperties;
import org.springframework.util.StringUtils;

public class NonAzureOpenAIKeyCredentialResolver
implements AzureCredentialResolver<NonAzureOpenAIKeyCredential> {
    public NonAzureOpenAIKeyCredential resolve(AzureProperties properties) {
        if (!this.isResolvable(properties)) {
            return null;
        }
        String key = ((OpenAIClientProperties)properties).getNonAzureOpenAIKey();
        if (!StringUtils.hasText((String)key)) {
            return null;
        }
        return new NonAzureOpenAIKeyCredential(key);
    }

    public boolean isResolvable(AzureProperties properties) {
        return properties instanceof OpenAIClientProperties;
    }
}

