/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.service.implementation.servicebus.factory;

import com.azure.core.amqp.AmqpRetryOptions;
import com.azure.core.amqp.AmqpTransportType;
import com.azure.core.amqp.ProxyOptions;
import com.azure.core.credential.TokenCredential;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.messaging.servicebus.ServiceBusClientBuilder;
import com.azure.spring.cloud.core.implementation.credential.descriptor.AuthenticationDescriptor;
import com.azure.spring.cloud.core.implementation.credential.descriptor.NamedKeyAuthenticationDescriptor;
import com.azure.spring.cloud.core.implementation.credential.descriptor.SasAuthenticationDescriptor;
import com.azure.spring.cloud.core.implementation.credential.descriptor.TokenAuthenticationDescriptor;
import com.azure.spring.cloud.core.implementation.factory.AbstractAzureAmqpClientBuilderFactory;
import com.azure.spring.cloud.core.implementation.properties.PropertyMapper;
import com.azure.spring.cloud.core.properties.AzureProperties;
import com.azure.spring.cloud.service.implementation.servicebus.properties.ServiceBusClientCommonProperties;
import com.azure.spring.cloud.service.implementation.servicebus.properties.ServiceBusNamespaceProperties;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;

public class ServiceBusClientBuilderFactory
extends AbstractAzureAmqpClientBuilderFactory<ServiceBusClientBuilder> {
    private final ServiceBusClientCommonProperties clientCommonProperties;

    public ServiceBusClientBuilderFactory(ServiceBusClientCommonProperties serviceBusProperties) {
        this.clientCommonProperties = serviceBusProperties;
    }

    protected BiConsumer<ServiceBusClientBuilder, ProxyOptions> consumeProxyOptions() {
        return ServiceBusClientBuilder::proxyOptions;
    }

    protected BiConsumer<ServiceBusClientBuilder, AmqpTransportType> consumeAmqpTransportType() {
        return ServiceBusClientBuilder::transportType;
    }

    protected BiConsumer<ServiceBusClientBuilder, AmqpRetryOptions> consumeAmqpRetryOptions() {
        return ServiceBusClientBuilder::retryOptions;
    }

    protected BiConsumer<ServiceBusClientBuilder, ClientOptions> consumeClientOptions() {
        return ServiceBusClientBuilder::clientOptions;
    }

    protected ServiceBusClientBuilder createBuilderInstance() {
        return new ServiceBusClientBuilder();
    }

    protected AzureProperties getAzureProperties() {
        return this.clientCommonProperties;
    }

    protected List<AuthenticationDescriptor<?>> getAuthenticationDescriptors(ServiceBusClientBuilder builder) {
        AuthenticationDescriptor[] authenticationDescriptorArray = new AuthenticationDescriptor[3];
        authenticationDescriptorArray[0] = new NamedKeyAuthenticationDescriptor(arg_0 -> ((ServiceBusClientBuilder)builder).credential(arg_0));
        authenticationDescriptorArray[1] = new SasAuthenticationDescriptor(arg_0 -> ((ServiceBusClientBuilder)builder).credential(arg_0));
        authenticationDescriptorArray[2] = new TokenAuthenticationDescriptor(this.tokenCredentialResolver, arg_0 -> ((ServiceBusClientBuilder)builder).credential(arg_0));
        return Arrays.asList(authenticationDescriptorArray);
    }

    protected void configureService(ServiceBusClientBuilder builder) {
        PropertyMapper mapper = new PropertyMapper();
        mapper.from((Object)this.clientCommonProperties.getFullyQualifiedNamespace()).to(arg_0 -> ((ServiceBusClientBuilder)builder).fullyQualifiedNamespace(arg_0));
        mapper.from((Object)this.clientCommonProperties.getCustomEndpointAddress()).to(arg_0 -> ((ServiceBusClientBuilder)builder).customEndpointAddress(arg_0));
        if (this.clientCommonProperties instanceof ServiceBusNamespaceProperties) {
            mapper.from((Object)((ServiceBusNamespaceProperties)this.clientCommonProperties).getCrossEntityTransactions()).whenTrue().to(t -> builder.enableCrossEntityTransactions());
        }
    }

    protected BiConsumer<ServiceBusClientBuilder, Configuration> consumeConfiguration() {
        return ServiceBusClientBuilder::configuration;
    }

    protected BiConsumer<ServiceBusClientBuilder, TokenCredential> consumeDefaultTokenCredential() {
        return (builder, tokenCredential) -> builder.credential(this.clientCommonProperties.getFullyQualifiedNamespace(), tokenCredential);
    }

    protected BiConsumer<ServiceBusClientBuilder, String> consumeConnectionString() {
        return ServiceBusClientBuilder::connectionString;
    }
}

