/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.service.implementation.storage.queue;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.spring.cloud.core.implementation.credential.descriptor.AuthenticationDescriptor;
import com.azure.spring.cloud.core.implementation.credential.descriptor.SasAuthenticationDescriptor;
import com.azure.spring.cloud.core.implementation.credential.descriptor.TokenAuthenticationDescriptor;
import com.azure.spring.cloud.core.implementation.properties.PropertyMapper;
import com.azure.spring.cloud.core.properties.AzureProperties;
import com.azure.spring.cloud.service.implementation.storage.common.AbstractAzureStorageClientBuilderFactory;
import com.azure.spring.cloud.service.implementation.storage.common.credential.StorageSharedKeyAuthenticationDescriptor;
import com.azure.spring.cloud.service.implementation.storage.queue.QueueServiceClientProperties;
import com.azure.storage.common.policy.RequestRetryOptions;
import com.azure.storage.queue.QueueServiceClientBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;

public class QueueServiceClientBuilderFactory
extends AbstractAzureStorageClientBuilderFactory<QueueServiceClientBuilder> {
    private final QueueServiceClientProperties queueServiceClientProperties;

    public QueueServiceClientBuilderFactory(QueueServiceClientProperties queueServiceClientProperties) {
        this.queueServiceClientProperties = queueServiceClientProperties;
    }

    protected BiConsumer<QueueServiceClientBuilder, ClientOptions> consumeClientOptions() {
        return QueueServiceClientBuilder::clientOptions;
    }

    protected BiConsumer<QueueServiceClientBuilder, HttpClient> consumeHttpClient() {
        return QueueServiceClientBuilder::httpClient;
    }

    protected BiConsumer<QueueServiceClientBuilder, HttpPipelinePolicy> consumeHttpPipelinePolicy() {
        return QueueServiceClientBuilder::addPolicy;
    }

    protected BiConsumer<QueueServiceClientBuilder, HttpPipeline> consumeHttpPipeline() {
        return QueueServiceClientBuilder::pipeline;
    }

    protected BiConsumer<QueueServiceClientBuilder, HttpLogOptions> consumeHttpLogOptions() {
        return QueueServiceClientBuilder::httpLogOptions;
    }

    protected QueueServiceClientBuilder createBuilderInstance() {
        return new QueueServiceClientBuilder();
    }

    protected AzureProperties getAzureProperties() {
        return this.queueServiceClientProperties;
    }

    protected List<AuthenticationDescriptor<?>> getAuthenticationDescriptors(QueueServiceClientBuilder builder) {
        AuthenticationDescriptor[] authenticationDescriptorArray = new AuthenticationDescriptor[3];
        authenticationDescriptorArray[0] = new StorageSharedKeyAuthenticationDescriptor(arg_0 -> ((QueueServiceClientBuilder)builder).credential(arg_0));
        authenticationDescriptorArray[1] = new SasAuthenticationDescriptor(arg_0 -> ((QueueServiceClientBuilder)builder).credential(arg_0));
        authenticationDescriptorArray[2] = new TokenAuthenticationDescriptor(this.tokenCredentialResolver, arg_0 -> ((QueueServiceClientBuilder)builder).credential(arg_0));
        return Arrays.asList(authenticationDescriptorArray);
    }

    protected void configureService(QueueServiceClientBuilder builder) {
        PropertyMapper map = new PropertyMapper();
        map.from((Object)this.queueServiceClientProperties.getMessageEncoding()).to(arg_0 -> ((QueueServiceClientBuilder)builder).messageEncoding(arg_0));
        map.from((Object)this.queueServiceClientProperties.getServiceVersion()).to(arg_0 -> ((QueueServiceClientBuilder)builder).serviceVersion(arg_0));
        map.from((Object)this.queueServiceClientProperties.getEndpoint()).to(arg_0 -> ((QueueServiceClientBuilder)builder).endpoint(arg_0));
    }

    protected BiConsumer<QueueServiceClientBuilder, Configuration> consumeConfiguration() {
        return QueueServiceClientBuilder::configuration;
    }

    protected BiConsumer<QueueServiceClientBuilder, TokenCredential> consumeDefaultTokenCredential() {
        return QueueServiceClientBuilder::credential;
    }

    protected BiConsumer<QueueServiceClientBuilder, String> consumeConnectionString() {
        return QueueServiceClientBuilder::connectionString;
    }

    @Override
    protected BiConsumer<QueueServiceClientBuilder, RequestRetryOptions> consumeRequestRetryOptions() {
        return QueueServiceClientBuilder::retryOptions;
    }
}

