/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.service.implementation.keyvault.certificates;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.security.keyvault.certificates.CertificateClientBuilder;
import com.azure.spring.cloud.core.implementation.credential.descriptor.AuthenticationDescriptor;
import com.azure.spring.cloud.core.implementation.credential.descriptor.TokenAuthenticationDescriptor;
import com.azure.spring.cloud.core.implementation.factory.AbstractAzureHttpClientBuilderFactory;
import com.azure.spring.cloud.core.implementation.properties.PropertyMapper;
import com.azure.spring.cloud.core.properties.AzureProperties;
import com.azure.spring.cloud.service.implementation.keyvault.certificates.CertificateClientProperties;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateClientBuilderFactory
extends AbstractAzureHttpClientBuilderFactory<CertificateClientBuilder> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CertificateClientBuilderFactory.class);
    private final CertificateClientProperties certificateClientProperties;

    public CertificateClientBuilderFactory(CertificateClientProperties certificateClientProperties) {
        this.certificateClientProperties = certificateClientProperties;
    }

    protected BiConsumer<CertificateClientBuilder, ClientOptions> consumeClientOptions() {
        return CertificateClientBuilder::clientOptions;
    }

    protected BiConsumer<CertificateClientBuilder, HttpClient> consumeHttpClient() {
        return CertificateClientBuilder::httpClient;
    }

    protected BiConsumer<CertificateClientBuilder, HttpPipelinePolicy> consumeHttpPipelinePolicy() {
        return CertificateClientBuilder::addPolicy;
    }

    protected BiConsumer<CertificateClientBuilder, HttpPipeline> consumeHttpPipeline() {
        return CertificateClientBuilder::pipeline;
    }

    protected BiConsumer<CertificateClientBuilder, HttpLogOptions> consumeHttpLogOptions() {
        return CertificateClientBuilder::httpLogOptions;
    }

    protected CertificateClientBuilder createBuilderInstance() {
        return new CertificateClientBuilder();
    }

    protected AzureProperties getAzureProperties() {
        return this.certificateClientProperties;
    }

    protected List<AuthenticationDescriptor<?>> getAuthenticationDescriptors(CertificateClientBuilder builder) {
        AuthenticationDescriptor[] authenticationDescriptorArray = new AuthenticationDescriptor[1];
        authenticationDescriptorArray[0] = new TokenAuthenticationDescriptor(this.tokenCredentialResolver, arg_0 -> ((CertificateClientBuilder)builder).credential(arg_0));
        return Arrays.asList(authenticationDescriptorArray);
    }

    protected void configureService(CertificateClientBuilder builder) {
        PropertyMapper map = new PropertyMapper();
        map.from((Object)this.certificateClientProperties.getEndpoint()).to(arg_0 -> ((CertificateClientBuilder)builder).vaultUrl(arg_0));
        map.from((Object)this.certificateClientProperties.getServiceVersion()).to(arg_0 -> ((CertificateClientBuilder)builder).serviceVersion(arg_0));
    }

    protected BiConsumer<CertificateClientBuilder, Configuration> consumeConfiguration() {
        return CertificateClientBuilder::configuration;
    }

    protected BiConsumer<CertificateClientBuilder, TokenCredential> consumeDefaultTokenCredential() {
        return CertificateClientBuilder::credential;
    }

    protected BiConsumer<CertificateClientBuilder, String> consumeConnectionString() {
        LOGGER.debug("Connection string is not supported to configure in CertificateClientBuilder");
        return (a, b) -> {};
    }

    protected BiConsumer<CertificateClientBuilder, RetryPolicy> consumeRetryPolicy() {
        return CertificateClientBuilder::retryPolicy;
    }
}

