/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.service.implementation.servicebus.lifecycle;

import com.azure.messaging.servicebus.ServiceBusProcessorClient;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.SmartLifecycle;

public class ServiceBusProcessorClientLifecycleManager
implements SmartLifecycle {
    private final Logger logger = LoggerFactory.getLogger(ServiceBusProcessorClientLifecycleManager.class);
    private final ServiceBusProcessorClient processorClient;

    public ServiceBusProcessorClientLifecycleManager(ServiceBusProcessorClient processorClient) {
        Objects.requireNonNull(processorClient);
        this.processorClient = processorClient;
    }

    public void start() {
        this.logger.debug("Starting Azure Service Bus processor client with queue name: {}, topic name: {} and subscription: {}", new Object[]{this.processorClient.getQueueName(), this.processorClient.getTopicName(), this.processorClient.getSubscriptionName()});
        this.processorClient.start();
    }

    public void stop() {
        this.logger.debug("Stopping Azure Service Bus processor client with queue name: {}, topic name: {} and subscription: {}", new Object[]{this.processorClient.getQueueName(), this.processorClient.getTopicName(), this.processorClient.getSubscriptionName()});
        this.processorClient.stop();
    }

    public boolean isRunning() {
        return this.processorClient.isRunning();
    }
}

