/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.service.implementation.kafka;

import com.azure.spring.cloud.core.implementation.properties.PropertyMapper;
import com.azure.spring.cloud.core.properties.AzureProperties;
import com.azure.spring.cloud.core.provider.AzureProfileOptionsProvider;
import com.azure.spring.cloud.service.implementation.jaas.Jaas;
import com.azure.spring.cloud.service.implementation.jaas.JaasResolver;
import com.azure.spring.cloud.service.implementation.passwordless.AzurePasswordlessProperties;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule;

public final class AzureKafkaPropertiesUtils {
    public static final String AZURE_TOKEN_CREDENTIAL = "azure.token.credential";
    private static final PropertyMapper PROPERTY_MAPPER = new PropertyMapper();
    static final String CREDENTIAL_PREFIX = "azure.credential.";
    static final String PROFILE_PREFIX = "azure.profile.";
    static final String ENVIRONMENT_PREFIX = "azure.profile.environment.";

    private AzureKafkaPropertiesUtils() {
    }

    public static void copyJaasPropertyToAzureProperties(String source, AzurePasswordlessProperties target) {
        JaasResolver resolver = new JaasResolver();
        Jaas jaas = resolver.resolve(source).orElse(new Jaas(OAuthBearerLoginModule.class.getName()));
        Map<String, String> map = jaas.getOptions();
        for (AzureKafkaPasswordlessPropertiesMapping m : AzureKafkaPasswordlessPropertiesMapping.values()) {
            PROPERTY_MAPPER.from((Object)map.get(m.propertyKey)).to(v -> m.setter.accept(target, (String)v));
        }
    }

    public static enum AzureKafkaPasswordlessPropertiesMapping {
        clientCertificatePassword("azure.credential.client-certificate-password", p -> p.getCredential().getClientCertificatePassword(), (p, s) -> p.getCredential().setClientCertificatePassword(s)),
        clientCertificatePath("azure.credential.client-certificate-path", p -> p.getCredential().getClientCertificatePath(), (p, s) -> p.getCredential().setClientCertificatePath(s)),
        clientId("azure.credential.client-id", p -> p.getCredential().getClientId(), (p, s) -> p.getCredential().setClientId(s)),
        clientSecret("azure.credential.client-secret", p -> p.getCredential().getClientSecret(), (p, s) -> p.getCredential().setClientSecret(s)),
        managedIdentityEnabled("azure.credential.managed-identity-enabled", p -> String.valueOf(p.getCredential().isManagedIdentityEnabled()), (p, s) -> p.getCredential().setManagedIdentityEnabled(Boolean.valueOf(s).booleanValue())),
        password("azure.credential.password", p -> p.getCredential().getPassword(), (p, s) -> p.getCredential().setPassword(s)),
        username("azure.credential.username", p -> p.getCredential().getUsername(), (p, s) -> p.getCredential().setUsername(s)),
        cloudType("azure.profile.cloud-type", p -> Optional.ofNullable(p.getProfile().getCloudType()).map(v -> v.name()).orElse(null), (p, s) -> p.getProfile().setCloudType(AzureProfileOptionsProvider.CloudType.fromString((String)s))),
        activeDirectoryEndpoint("azure.profile.environment.active-directory-endpoint", p -> p.getProfile().getEnvironment().getActiveDirectoryEndpoint(), (p, s) -> p.getProfile().getEnvironment().setActiveDirectoryEndpoint(s)),
        activeDirectoryGraphApiVersion("azure.profile.environment.active-directory-graph-api-version", p -> p.getProfile().getEnvironment().getActiveDirectoryGraphApiVersion(), (p, s) -> p.getProfile().getEnvironment().setActiveDirectoryGraphApiVersion(s)),
        activeDirectoryGraphEndpoint("azure.profile.environment.active-directory-graph-endpoint", p -> p.getProfile().getEnvironment().getActiveDirectoryGraphEndpoint(), (p, s) -> p.getProfile().getEnvironment().setActiveDirectoryGraphEndpoint(s)),
        activeDirectoryResourceId("azure.profile.environment.active-directory-resource-id", p -> p.getProfile().getEnvironment().getActiveDirectoryResourceId(), (p, s) -> p.getProfile().getEnvironment().setActiveDirectoryResourceId(s)),
        azureApplicationInsightsEndpoint("azure.profile.environment.azure-application-insights-endpoint", p -> p.getProfile().getEnvironment().getAzureApplicationInsightsEndpoint(), (p, s) -> p.getProfile().getEnvironment().setAzureApplicationInsightsEndpoint(s)),
        azureDataLakeAnalyticsCatalogAndJobEndpointSuffix("azure.profile.environment.azure-data-lake-analytics-catalog-and-job-endpoint-suffix", p -> p.getProfile().getEnvironment().getAzureDataLakeAnalyticsCatalogAndJobEndpointSuffix(), (p, s) -> p.getProfile().getEnvironment().setAzureDataLakeAnalyticsCatalogAndJobEndpointSuffix(s)),
        azureDataLakeStoreFileSystemEndpointSuffix("azure.profile.environment.azure-data-lake-store-file-system-endpoint-suffix", p -> p.getProfile().getEnvironment().getAzureDataLakeStoreFileSystemEndpointSuffix(), (p, s) -> p.getProfile().getEnvironment().setAzureDataLakeStoreFileSystemEndpointSuffix(s)),
        azureLogAnalyticsEndpoint("azure.profile.environment.azure-log-analytics-endpoint", p -> p.getProfile().getEnvironment().getAzureLogAnalyticsEndpoint(), (p, s) -> p.getProfile().getEnvironment().setAzureLogAnalyticsEndpoint(s)),
        dataLakeEndpointResourceId("azure.profile.environment.data-lake-endpoint-resource-id", p -> p.getProfile().getEnvironment().getDataLakeEndpointResourceId(), (p, s) -> p.getProfile().getEnvironment().setDataLakeEndpointResourceId(s)),
        galleryEndpoint("azure.profile.environment.gallery-endpoint", p -> p.getProfile().getEnvironment().getGalleryEndpoint(), (p, s) -> p.getProfile().getEnvironment().setGalleryEndpoint(s)),
        keyVaultDnsSuffix("azure.profile.environment.key-vault-dns-suffix", p -> p.getProfile().getEnvironment().getKeyVaultDnsSuffix(), (p, s) -> p.getProfile().getEnvironment().setKeyVaultDnsSuffix(s)),
        managementEndpoint("azure.profile.environment.management-endpoint", p -> p.getProfile().getEnvironment().getManagementEndpoint(), (p, s) -> p.getProfile().getEnvironment().setManagementEndpoint(s)),
        microsoftGraphEndpoint("azure.profile.environment.microsoft-graph-endpoint", p -> p.getProfile().getEnvironment().getMicrosoftGraphEndpoint(), (p, s) -> p.getProfile().getEnvironment().setMicrosoftGraphEndpoint(s)),
        portal("azure.profile.environment.portal", p -> p.getProfile().getEnvironment().getPortal(), (p, s) -> p.getProfile().getEnvironment().setPortal(s)),
        publishingProfile("azure.profile.environment.publishing-profile", p -> p.getProfile().getEnvironment().getPublishingProfile(), (p, s) -> p.getProfile().getEnvironment().setPublishingProfile(s)),
        resourceManagerEndpoint("azure.profile.environment.resource-manager-endpoint", p -> p.getProfile().getEnvironment().getResourceManagerEndpoint(), (p, s) -> p.getProfile().getEnvironment().setResourceManagerEndpoint(s)),
        sqlManagementEndpoint("azure.profile.environment.sql-management-endpoint", p -> p.getProfile().getEnvironment().getSqlManagementEndpoint(), (p, s) -> p.getProfile().getEnvironment().setSqlManagementEndpoint(s)),
        sqlServerHostnameSuffix("azure.profile.environment.sql-server-hostname-suffix", p -> p.getProfile().getEnvironment().getSqlServerHostnameSuffix(), (p, s) -> p.getProfile().getEnvironment().setSqlServerHostnameSuffix(s)),
        storageEndpointSuffix("azure.profile.environment.storage-endpoint-suffix", p -> p.getProfile().getEnvironment().getStorageEndpointSuffix(), (p, s) -> p.getProfile().getEnvironment().setStorageEndpointSuffix(s)),
        subscriptionId("azure.profile.subscription-id", p -> p.getProfile().getSubscriptionId(), (p, s) -> p.getProfile().setSubscriptionId(s)),
        tenantId("azure.profile.tenant-id", p -> p.getProfile().getTenantId(), (p, s) -> p.getProfile().setTenantId(s));

        private static final List<String> PROPERTY_KEYS;
        private String propertyKey;
        private Function<AzureProperties, String> getter;
        private BiConsumer<AzurePasswordlessProperties, String> setter;

        public static List<String> getPropertyKeys() {
            return PROPERTY_KEYS;
        }

        private static List<String> buildPropertyKeys() {
            return Collections.unmodifiableList(Stream.of(AzureKafkaPasswordlessPropertiesMapping.values()).map(m -> m.propertyKey).collect(Collectors.toList()));
        }

        private AzureKafkaPasswordlessPropertiesMapping(String propertyKey, Function<AzureProperties, String> getter, BiConsumer<AzurePasswordlessProperties, String> setter) {
            this.propertyKey = propertyKey;
            this.getter = getter;
            this.setter = setter;
        }

        public String propertyKey() {
            return this.propertyKey;
        }

        public Function<AzureProperties, String> getter() {
            return this.getter;
        }

        public BiConsumer<AzurePasswordlessProperties, String> setter() {
            return this.setter;
        }

        static {
            PROPERTY_KEYS = AzureKafkaPasswordlessPropertiesMapping.buildPropertyKeys();
        }
    }
}

