/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.monitor.implementation;

import com.azure.spring.cloud.autoconfigure.monitor.implementation.OTelVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;

class OpenTelemetryVersionCheckRunner
implements CommandLineRunner {
    private static final Logger LOG = LoggerFactory.getLogger(OpenTelemetryVersionCheckRunner.class);
    static final String STARTER_OTEL_VERSION = "1.48.0";

    OpenTelemetryVersionCheckRunner() {
    }

    public void run(String ... args) {
        try {
            OTelVersion currentOtelVersion = new OTelVersion(STARTER_OTEL_VERSION);
            OTelVersion starterOTelVersion = new OTelVersion(STARTER_OTEL_VERSION);
            OpenTelemetryVersionCheckRunner.checkOpenTelemetryVersion(currentOtelVersion, starterOTelVersion);
        }
        catch (Exception e) {
            LOG.warn("An unexpected issue has happened during the verification of the OpenTelemetry version.", (Throwable)e);
        }
    }

    private static void checkOpenTelemetryVersion(OTelVersion currentOTelVersion, OTelVersion starterOTelVersion) {
        if (!currentOTelVersion.hasSameMajorVersionAs(starterOTelVersion)) {
            LOG.warn("Spring Boot and the spring-cloud-azure-starter-monitor dependency have different OpenTelemetry major versions (respectively " + currentOTelVersion.majorVersion + " and " + starterOTelVersion.majorVersion + ") . This will likely cause unexpected behaviors.");
        } else if (currentOTelVersion.isLessThan(starterOTelVersion)) {
            LOG.warn("The OpenTelemetry version is not compatible with the spring-cloud-azure-starter-monitor dependency. The OpenTelemetry version should be 1.48.0 or later. Please look at the spring-cloud-azure-starter-monitor documentation to fix this.");
        } else if (currentOTelVersion.isGreaterThan(starterOTelVersion)) {
            LOG.debug("A new version of spring-cloud-azure-starter-monitor dependency may be available.");
        }
    }
}

