/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.monitor.implementation.selfdiagnostics;

import com.azure.spring.cloud.autoconfigure.monitor.implementation.selfdiagnostics.SelfDiagnostics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnMissingClass(value={"ch.qos.logback.classic.LoggerContext"})
class DefaultLogConfig {
    DefaultLogConfig() {
    }

    @Bean
    Logger selfDiagnosticsLogger() {
        Logger logger = LoggerFactory.getLogger(SelfDiagnostics.class);
        String selfDiagLevelDefinedByUser = System.getenv("APPLICATIONINSIGHTS_SELF_DIAGNOSTICS_LEVEL");
        if (selfDiagLevelDefinedByUser != null) {
            String loggerLevel = DefaultLogConfig.findLevel(logger);
            logger.warn("You have defined a self-diagnostics level at " + selfDiagLevelDefinedByUser + ". The self-diagnostics level was not set to this value because Logback is not used. The self-diagnostics level is " + loggerLevel + ".");
        }
        return logger;
    }

    private static String findLevel(Logger logger) {
        if (logger.isErrorEnabled()) {
            return "ERROR";
        }
        if (logger.isWarnEnabled()) {
            return "WARN";
        }
        if (logger.isInfoEnabled()) {
            return "INFO";
        }
        if (logger.isDebugEnabled()) {
            return "DEBUG";
        }
        if (logger.isTraceEnabled()) {
            return "TRACE";
        }
        return "UNKNOWN";
    }
}

