/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.monitor.implementation.selfdiagnostics;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.spring.autoconfigure.OpenTelemetryAutoConfiguration;
import org.slf4j.Logger;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.ApplicationContext;

class OtelSelfDiag
implements CommandLineRunner {
    private final ApplicationContext applicationContext;
    private final Logger selfDiagnosticsLogger;

    OtelSelfDiag(ApplicationContext applicationContext, Logger selfDiagnosticsLogger) {
        this.applicationContext = applicationContext;
        this.selfDiagnosticsLogger = selfDiagnosticsLogger;
    }

    public void run(String ... args) {
        try {
            this.executeOtelSelfDiagnostics();
        }
        catch (Exception e) {
            this.selfDiagnosticsLogger.warn("An unexpected issue has happened during OpenTelemetry self-diagnostics.", (Throwable)e);
        }
    }

    private void executeOtelSelfDiagnostics() {
        if (!this.selfDiagnosticsLogger.isDebugEnabled()) {
            return;
        }
        if (this.applicationContext instanceof BeanDefinitionRegistry) {
            BeanDefinitionRegistry beanDefinitionRegistry = (BeanDefinitionRegistry)this.applicationContext;
            this.checkBeanComesFromOtelJavaInstrumentationConfig(beanDefinitionRegistry, OpenTelemetry.class);
        }
        if (this.isOpenTelemetryNoop()) {
            this.selfDiagnosticsLogger.debug("NOOP OpenTelemetry");
        }
    }

    private void checkBeanComesFromOtelJavaInstrumentationConfig(BeanDefinitionRegistry beanDefinitionRegistry, Class<?> clazz) {
        boolean isOtelFactoryBean;
        String[] beanNames = this.applicationContext.getBeanNamesForType(clazz);
        String beanName = beanNames[0];
        BeanDefinition beanDefinition = beanDefinitionRegistry.getBeanDefinition(beanName);
        String factoryBeanName = beanDefinition.getFactoryBeanName();
        if (factoryBeanName != null && !(isOtelFactoryBean = factoryBeanName.startsWith(OpenTelemetryAutoConfiguration.class.getName()))) {
            this.selfDiagnosticsLogger.debug("We do not recommend to define a bean of type " + String.valueOf(clazz) + ". ");
        }
    }

    private boolean isOpenTelemetryNoop() {
        OpenTelemetry openTelemetry = (OpenTelemetry)this.applicationContext.getBean(OpenTelemetry.class);
        return openTelemetry.equals((Object)OpenTelemetry.noop());
    }
}

