/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.monitor.implementation.selfdiagnostics;

import com.azure.spring.cloud.autoconfigure.monitor.implementation.selfdiagnostics.DefaultLogConfig;
import com.azure.spring.cloud.autoconfigure.monitor.implementation.selfdiagnostics.LogbackSelfDiagConfig;
import com.azure.spring.cloud.autoconfigure.monitor.implementation.selfdiagnostics.OtelSelfDiag;
import com.azure.spring.cloud.autoconfigure.monitor.implementation.selfdiagnostics.SelfDiagnosticsLevel;
import com.azure.spring.cloud.autoconfigure.monitor.implementation.selfdiagnostics.SpringEnvSelfDiag;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(name={"otel.sdk.disabled"}, havingValue="false", matchIfMissing=true)
@Import(value={DefaultLogConfig.class, LogbackSelfDiagConfig.class})
class SelfDiagAutoConfig {
    private static final Logger LOG = LoggerFactory.getLogger(SelfDiagAutoConfig.class);
    static final String SELF_DIAGNOSTICS_LEVEL_ENV_VAR = "APPLICATIONINSIGHTS_SELF_DIAGNOSTICS_LEVEL";

    SelfDiagAutoConfig() {
    }

    @Bean
    SelfDiagnosticsLevel selfDiagnosticsLevel() {
        String selfDiagLevelEnvVar = System.getenv(SELF_DIAGNOSTICS_LEVEL_ENV_VAR);
        if (selfDiagLevelEnvVar == null) {
            return SelfDiagnosticsLevel.INFO;
        }
        try {
            String upperCaseLevel = selfDiagLevelEnvVar.toUpperCase(Locale.ROOT);
            return SelfDiagnosticsLevel.valueOf(upperCaseLevel);
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Unable to find the self-diagnostics level related to " + selfDiagLevelEnvVar + "defined with APPLICATIONINSIGHTS_SELF_DIAGNOSTICS_LEVEL environment variable.", (Throwable)e);
            return SelfDiagnosticsLevel.INFO;
        }
    }

    @Bean
    OtelSelfDiag otelSelfDiag(ApplicationContext applicationContext, Logger selfDiagnosticsLogger) {
        return new OtelSelfDiag(applicationContext, selfDiagnosticsLogger);
    }

    @Bean
    SpringEnvSelfDiag springPropertiesSelfDiagnostic(Environment environment, Logger selfDiagnosticsLogger) {
        return new SpringEnvSelfDiag(environment, selfDiagnosticsLogger);
    }
}

