/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.monitor.implementation.selfdiagnostics;

import java.util.AbstractMap;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;

class SpringEnvSelfDiag
implements CommandLineRunner {
    private final Environment environment;
    private final Logger selfDiagnosticsLogger;

    SpringEnvSelfDiag(Environment environment, Logger selfDiagnosticsLogger) {
        this.environment = environment;
        this.selfDiagnosticsLogger = selfDiagnosticsLogger;
    }

    public void run(String ... args) {
        if (!this.selfDiagnosticsLogger.isTraceEnabled()) {
            return;
        }
        try {
            this.executeSpringEnvSelfDiag();
        }
        catch (Exception e) {
            this.selfDiagnosticsLogger.warn("An unexpected issue has happened during Spring env self-diagnostics.", (Throwable)e);
        }
    }

    private void executeSpringEnvSelfDiag() {
        if (this.environment instanceof ConfigurableEnvironment) {
            ConfigurableEnvironment configurableEnvironment = (ConfigurableEnvironment)this.environment;
            String env = SpringEnvSelfDiag.buildEnvAsString(configurableEnvironment);
            this.selfDiagnosticsLogger.trace("Env: " + env);
        }
    }

    private static String buildEnvAsString(ConfigurableEnvironment configurableEnvironment) {
        return StreamSupport.stream(configurableEnvironment.getPropertySources().spliterator(), false).map(PropertySource::getSource).filter(source -> source instanceof Map).flatMap(source -> ((Map)source).entrySet().stream()).map(entry -> {
            String value = SpringEnvSelfDiag.isSensitive(entry) ? "***" : entry.getValue().toString();
            return new AbstractMap.SimpleEntry<String, String>(entry.getKey().toString(), value);
        }).map(AbstractMap.SimpleEntry::toString).collect(Collectors.joining(", "));
    }

    private static boolean isSensitive(Map.Entry<?, ?> entry) {
        String key = entry.getKey().toString().toLowerCase(Locale.ROOT);
        return key.contains("password") || key.contains("pwd") || key.contains("secret");
    }
}

