/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.stream.binder.servicebus;

import com.azure.spring.cloud.stream.binder.servicebus.ServiceBusMessageChannelBinder;
import com.azure.spring.integration.instrumentation.Instrumentation;
import com.azure.spring.integration.instrumentation.InstrumentationManager;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;

public class ServiceBusHealthIndicator
extends AbstractHealthIndicator {
    private final InstrumentationManager instrumentationManager;

    public ServiceBusHealthIndicator(ServiceBusMessageChannelBinder binder) {
        super("Service bus health check failed");
        this.instrumentationManager = binder.getInstrumentationManager();
    }

    protected void doHealthCheck(Health.Builder builder) {
        if (this.instrumentationManager == null || this.instrumentationManager.getHealthInstrumentations().isEmpty()) {
            builder.unknown();
            return;
        }
        if (this.instrumentationManager.getHealthInstrumentations().stream().allMatch(Instrumentation::isUp)) {
            builder.up();
            return;
        }
        builder.down();
        this.instrumentationManager.getHealthInstrumentations().stream().filter(instrumentation -> instrumentation.isDown()).forEach(instrumentation -> builder.withDetail(instrumentation.getId(), (Object)instrumentation.getException()));
    }
}

