/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.stream.binder.servicebus;

import com.azure.messaging.servicebus.ServiceBusReceivedMessageContext;
import com.azure.spring.cloud.stream.binder.servicebus.properties.ServiceBusConsumerProperties;
import com.azure.spring.cloud.stream.binder.servicebus.properties.ServiceBusExtendedBindingProperties;
import com.azure.spring.cloud.stream.binder.servicebus.properties.ServiceBusProducerProperties;
import com.azure.spring.cloud.stream.binder.servicebus.provisioning.ServiceBusChannelProvisioner;
import com.azure.spring.integration.handler.DefaultMessageHandler;
import com.azure.spring.integration.instrumentation.DefaultInstrumentation;
import com.azure.spring.integration.instrumentation.DefaultInstrumentationManager;
import com.azure.spring.integration.instrumentation.Instrumentation;
import com.azure.spring.integration.instrumentation.InstrumentationManager;
import com.azure.spring.integration.instrumentation.InstrumentationSendCallback;
import com.azure.spring.integration.servicebus.inbound.ServiceBusInboundChannelAdapter;
import com.azure.spring.integration.servicebus.inbound.health.ServiceBusProcessorInstrumentation;
import com.azure.spring.messaging.PropertiesSupplier;
import com.azure.spring.messaging.checkpoint.CheckpointConfig;
import com.azure.spring.messaging.core.SendOperation;
import com.azure.spring.servicebus.core.ServiceBusProcessorContainer;
import com.azure.spring.servicebus.core.ServiceBusTemplate;
import com.azure.spring.servicebus.core.processor.DefaultServiceBusNamespaceProcessorFactory;
import com.azure.spring.servicebus.core.processor.ServiceBusProcessorFactory;
import com.azure.spring.servicebus.core.producer.DefaultServiceBusNamespaceProducerFactory;
import com.azure.spring.servicebus.core.producer.ServiceBusProducerFactory;
import com.azure.spring.servicebus.core.properties.NamespaceProperties;
import com.azure.spring.servicebus.core.properties.ProcessorProperties;
import com.azure.spring.servicebus.core.properties.ProducerProperties;
import com.azure.spring.servicebus.support.converter.ServiceBusMessageConverter;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.stream.binder.AbstractMessageChannelBinder;
import org.springframework.cloud.stream.binder.BinderSpecificPropertiesProvider;
import org.springframework.cloud.stream.binder.ConsumerProperties;
import org.springframework.cloud.stream.binder.ExtendedConsumerProperties;
import org.springframework.cloud.stream.binder.ExtendedProducerProperties;
import org.springframework.cloud.stream.binder.ExtendedPropertiesBinder;
import org.springframework.cloud.stream.provisioning.ConsumerDestination;
import org.springframework.cloud.stream.provisioning.ProducerDestination;
import org.springframework.cloud.stream.provisioning.ProvisioningProvider;
import org.springframework.expression.Expression;
import org.springframework.integration.core.MessageProducer;
import org.springframework.integration.expression.FunctionExpression;
import org.springframework.integration.support.DefaultErrorMessageStrategy;
import org.springframework.integration.support.ErrorMessageStrategy;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.support.ErrorMessage;
import org.springframework.util.Assert;
import org.springframework.util.concurrent.ListenableFutureCallback;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

public class ServiceBusMessageChannelBinder
extends AbstractMessageChannelBinder<ExtendedConsumerProperties<ServiceBusConsumerProperties>, ExtendedProducerProperties<ServiceBusProducerProperties>, ServiceBusChannelProvisioner>
implements ExtendedPropertiesBinder<MessageChannel, ServiceBusConsumerProperties, ServiceBusProducerProperties> {
    private ServiceBusExtendedBindingProperties bindingProperties = new ServiceBusExtendedBindingProperties();
    private NamespaceProperties namespaceProperties;
    private ServiceBusTemplate serviceBusTemplate;
    private ServiceBusProcessorContainer processorContainer;
    private ServiceBusMessageConverter messageConverter = new ServiceBusMessageConverter();
    private final InstrumentationManager instrumentationManager = new DefaultInstrumentationManager();
    private final Map<String, ExtendedProducerProperties<ServiceBusProducerProperties>> extendedProducerPropertiesMap = new ConcurrentHashMap<String, ExtendedProducerProperties<ServiceBusProducerProperties>>();
    private final Map<Tuple2<String, String>, ExtendedConsumerProperties<ServiceBusConsumerProperties>> extendedConsumerPropertiesMap = new ConcurrentHashMap<Tuple2<String, String>, ExtendedConsumerProperties<ServiceBusConsumerProperties>>();
    private static final DefaultErrorMessageStrategy DEFAULT_ERROR_MESSAGE_STRATEGY = new DefaultErrorMessageStrategy();
    private static final String EXCEPTION_MESSAGE = "exception-message";
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceBusMessageChannelBinder.class);

    public ServiceBusMessageChannelBinder(String[] headersToEmbed, ServiceBusChannelProvisioner provisioningProvider) {
        super(headersToEmbed, (ProvisioningProvider)provisioningProvider);
    }

    protected MessageHandler createProducerMessageHandler(ProducerDestination destination, ExtendedProducerProperties<ServiceBusProducerProperties> producerProperties, MessageChannel errorChannel) {
        Assert.notNull((Object)this.getServiceBusTemplate(), (String)"ServiceBusTemplate can't be null when create a producer");
        this.extendedProducerPropertiesMap.put(destination.getName(), producerProperties);
        DefaultMessageHandler handler = new DefaultMessageHandler(destination.getName(), (SendOperation)this.serviceBusTemplate);
        handler.setBeanFactory((BeanFactory)this.getBeanFactory());
        handler.setSync(((ServiceBusProducerProperties)producerProperties.getExtension()).isSync());
        handler.setSendTimeout(((ServiceBusProducerProperties)producerProperties.getExtension()).getSendTimeout());
        handler.setSendFailureChannel(errorChannel);
        String instrumentationId = Instrumentation.buildId((Instrumentation.Type)Instrumentation.Type.PRODUCER, (String)destination.getName());
        handler.setSendCallback((ListenableFutureCallback)new InstrumentationSendCallback(instrumentationId, this.instrumentationManager));
        if (producerProperties.isPartitioned()) {
            handler.setPartitionKeyExpressionString("'partitionKey-' + headers['scst_partition']");
        } else {
            handler.setPartitionKeyExpression((Expression)new FunctionExpression(m -> m.getPayload().hashCode()));
        }
        return handler;
    }

    protected MessageProducer createConsumerEndpoint(ConsumerDestination destination, String group, ExtendedConsumerProperties<ServiceBusConsumerProperties> properties) {
        if (group == null) {
            group = DefaultServiceBusNamespaceProcessorFactory.INVALID_SUBSCRIPTION;
        }
        this.extendedConsumerPropertiesMap.put((Tuple2<String, String>)Tuples.of((Object)destination.getName(), (Object)group), properties);
        ServiceBusInboundChannelAdapter inboundAdapter = !DefaultServiceBusNamespaceProcessorFactory.INVALID_SUBSCRIPTION.equals(group) ? new ServiceBusInboundChannelAdapter(this.getProcessorContainer(), destination.getName(), group, this.buildCheckpointConfig(properties)) : new ServiceBusInboundChannelAdapter(this.getProcessorContainer(), destination.getName(), this.buildCheckpointConfig(properties));
        inboundAdapter.setBeanFactory((BeanFactory)this.getBeanFactory());
        String instrumentationId = Instrumentation.buildId((Instrumentation.Type)Instrumentation.Type.CONSUMER, (String)(destination.getName() + "/" + (!DefaultServiceBusNamespaceProcessorFactory.INVALID_SUBSCRIPTION.equals(group) ? group : "")));
        inboundAdapter.setInstrumentationManager(this.instrumentationManager);
        inboundAdapter.setInstrumentationId(instrumentationId);
        AbstractMessageChannelBinder.ErrorInfrastructure errorInfrastructure = this.registerErrorInfrastructure(destination, !DefaultServiceBusNamespaceProcessorFactory.INVALID_SUBSCRIPTION.equals(group) ? group : "", (ConsumerProperties)properties);
        inboundAdapter.setErrorChannel((MessageChannel)errorInfrastructure.getErrorChannel());
        inboundAdapter.setMessageConverter(this.messageConverter);
        return inboundAdapter;
    }

    protected MessageHandler getErrorMessageHandler(ConsumerDestination destination, String group, ExtendedConsumerProperties<ServiceBusConsumerProperties> properties) {
        return message -> {
            Assert.state((boolean)(message instanceof ErrorMessage), (String)("Expected an ErrorMessage, not a " + message.getClass().toString() + " for: " + message));
            ErrorMessage errorMessage = (ErrorMessage)message;
            Message amqpMessage = errorMessage.getOriginalMessage();
            if (amqpMessage == null) {
                this.logger.error((Object)("No raw message header in " + message));
            } else {
                Throwable cause = (Throwable)message.getPayload();
                if (((ServiceBusConsumerProperties)properties.getExtension()).isRequeueRejected()) {
                    this.deadLetter(destination.getName(), amqpMessage, EXCEPTION_MESSAGE, cause.getCause() != null ? cause.getCause().getMessage() : cause.getMessage());
                } else {
                    this.abandon(destination.getName(), amqpMessage);
                }
            }
        };
    }

    public <T> void deadLetter(String destination, Message<T> message, String deadLetterReason, String deadLetterErrorDescription) {
        Assert.hasText((String)destination, (String)"destination can't be null or empty");
        ServiceBusReceivedMessageContext messageContext = (ServiceBusReceivedMessageContext)message.getHeaders().get((Object)"azure_service_bus_received_message_context");
        if (messageContext != null) {
            messageContext.deadLetter();
        }
    }

    public <T> void abandon(String destination, Message<T> message) {
        Assert.hasText((String)destination, (String)"destination can't be null or empty");
        ServiceBusReceivedMessageContext messageContext = (ServiceBusReceivedMessageContext)message.getHeaders().get((Object)"azure_service_bus_received_message_context");
        if (messageContext != null) {
            messageContext.abandon();
        }
    }

    public ServiceBusConsumerProperties getExtendedConsumerProperties(String channelName) {
        return (ServiceBusConsumerProperties)this.bindingProperties.getExtendedConsumerProperties(channelName);
    }

    public ServiceBusProducerProperties getExtendedProducerProperties(String channelName) {
        return (ServiceBusProducerProperties)this.bindingProperties.getExtendedProducerProperties(channelName);
    }

    public String getDefaultsPrefix() {
        return this.bindingProperties.getDefaultsPrefix();
    }

    public Class<? extends BinderSpecificPropertiesProvider> getExtendedPropertiesEntryClass() {
        return this.bindingProperties.getExtendedPropertiesEntryClass();
    }

    protected ErrorMessageStrategy getErrorMessageStrategy() {
        return DEFAULT_ERROR_MESSAGE_STRATEGY;
    }

    public void setBindingProperties(ServiceBusExtendedBindingProperties bindingProperties) {
        this.bindingProperties = bindingProperties;
    }

    private CheckpointConfig buildCheckpointConfig(ExtendedConsumerProperties<ServiceBusConsumerProperties> properties) {
        return new CheckpointConfig(((ServiceBusConsumerProperties)properties.getExtension()).getCheckpointMode());
    }

    private ServiceBusTemplate getServiceBusTemplate() {
        if (this.serviceBusTemplate == null) {
            DefaultServiceBusNamespaceProducerFactory factory = new DefaultServiceBusNamespaceProducerFactory(this.namespaceProperties, this.getProducerPropertiesSupplier());
            factory.addListener((name, client) -> {
                DefaultInstrumentation instrumentation = new DefaultInstrumentation(name, Instrumentation.Type.PRODUCER);
                instrumentation.markUp();
                this.instrumentationManager.addHealthInstrumentation(instrumentation.getId(), (Instrumentation)instrumentation);
            });
            this.serviceBusTemplate = new ServiceBusTemplate((ServiceBusProducerFactory)factory);
        }
        return this.serviceBusTemplate;
    }

    private ServiceBusProcessorContainer getProcessorContainer() {
        if (this.processorContainer == null) {
            DefaultServiceBusNamespaceProcessorFactory factory = new DefaultServiceBusNamespaceProcessorFactory(this.namespaceProperties, this.getProcessorPropertiesSupplier());
            factory.addListener((name, subscription, client) -> {
                String instrumentationName = name + "/" + subscription == null ? "" : subscription;
                ServiceBusProcessorInstrumentation instrumentation = new ServiceBusProcessorInstrumentation(instrumentationName, Instrumentation.Type.CONSUMER, Duration.ofMinutes(2L));
                instrumentation.markUp();
                this.instrumentationManager.addHealthInstrumentation(instrumentation.getId(), (Instrumentation)instrumentation);
            });
            this.processorContainer = new ServiceBusProcessorContainer((ServiceBusProcessorFactory)factory);
        }
        return this.processorContainer;
    }

    private PropertiesSupplier<String, ProducerProperties> getProducerPropertiesSupplier() {
        return key -> {
            if (this.extendedProducerPropertiesMap.containsKey(key)) {
                ServiceBusProducerProperties producerProperties = (ServiceBusProducerProperties)this.extendedProducerPropertiesMap.get(key).getExtension();
                producerProperties.setEntityName(key);
                return producerProperties;
            }
            LOGGER.debug("Can't find extended properties for {}", key);
            return null;
        };
    }

    private PropertiesSupplier<Tuple2<String, String>, ProcessorProperties> getProcessorPropertiesSupplier() {
        return key -> {
            if (this.extendedConsumerPropertiesMap.containsKey(key)) {
                ServiceBusConsumerProperties consumerProperties = (ServiceBusConsumerProperties)this.extendedConsumerPropertiesMap.get(key).getExtension();
                consumerProperties.setEntityName((String)key.getT1());
                consumerProperties.setSubscriptionName((String)key.getT2());
                return consumerProperties;
            }
            LOGGER.debug("Can't find extended properties for destination {}, group {}", key.getT1(), key.getT2());
            return null;
        };
    }

    public void setNamespaceProperties(NamespaceProperties namespaceProperties) {
        this.namespaceProperties = namespaceProperties;
    }

    public void setMessageConverter(ServiceBusMessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    public InstrumentationManager getInstrumentationManager() {
        return this.instrumentationManager;
    }
}

