/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.stream.binder.servicebus.provisioning;

import com.azure.spring.cloud.resourcemanager.provisioner.servicebus.ServiceBusProvisioner;
import com.azure.spring.cloud.stream.binder.servicebus.provisioning.ServiceBusChannelProvisioner;
import com.azure.spring.service.servicebus.properties.ServiceBusEntityType;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public class ServiceBusChannelResourceManagerProvisioner
extends ServiceBusChannelProvisioner {
    private final String namespace;
    private final ServiceBusProvisioner serviceBusProvisioner;

    public ServiceBusChannelResourceManagerProvisioner(@NonNull String namespace, @NonNull ServiceBusProvisioner serviceBusProvisioner) {
        Assert.hasText((String)namespace, (String)"The namespace can't be null or empty");
        this.namespace = namespace;
        this.serviceBusProvisioner = serviceBusProvisioner;
    }

    protected void validateOrCreateForConsumer(String name, String group, ServiceBusEntityType type) {
        if (ServiceBusEntityType.QUEUE == type) {
            this.serviceBusProvisioner.provisionQueue(this.namespace, name);
        } else {
            this.serviceBusProvisioner.provisionSubscription(this.namespace, name, group);
        }
    }

    protected void validateOrCreateForProducer(String name, ServiceBusEntityType type) {
        if (ServiceBusEntityType.QUEUE == type) {
            this.serviceBusProvisioner.provisionQueue(this.namespace, name);
        } else {
            this.serviceBusProvisioner.provisionTopic(this.namespace, name);
        }
    }
}

