/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.stream.binder.servicebus.implementation.config;

import com.azure.core.credential.TokenCredential;
import com.azure.messaging.servicebus.ServiceBusClientBuilder;
import com.azure.messaging.servicebus.ServiceBusMessage;
import com.azure.messaging.servicebus.ServiceBusReceivedMessage;
import com.azure.spring.cloud.autoconfigure.implementation.context.AzureGlobalPropertiesAutoConfiguration;
import com.azure.spring.cloud.autoconfigure.implementation.context.AzureTokenCredentialAutoConfiguration;
import com.azure.spring.cloud.autoconfigure.implementation.resourcemanager.AzureResourceManagerAutoConfiguration;
import com.azure.spring.cloud.autoconfigure.implementation.resourcemanager.AzureServiceBusResourceManagerAutoConfiguration;
import com.azure.spring.cloud.autoconfigure.implementation.servicebus.AzureServiceBusAutoConfiguration;
import com.azure.spring.cloud.autoconfigure.implementation.servicebus.AzureServiceBusMessagingAutoConfiguration;
import com.azure.spring.cloud.autoconfigure.implementation.servicebus.properties.AzureServiceBusProperties;
import com.azure.spring.cloud.core.credential.AzureCredentialResolver;
import com.azure.spring.cloud.core.customizer.AzureServiceClientBuilderCustomizer;
import com.azure.spring.cloud.core.implementation.credential.resolver.AzureTokenCredentialResolver;
import com.azure.spring.cloud.resourcemanager.implementation.provisioning.ServiceBusProvisioner;
import com.azure.spring.cloud.stream.binder.servicebus.config.ServiceBusProcessorFactoryCustomizer;
import com.azure.spring.cloud.stream.binder.servicebus.config.ServiceBusProducerFactoryCustomizer;
import com.azure.spring.cloud.stream.binder.servicebus.core.implementation.provisioning.ServiceBusChannelProvisioner;
import com.azure.spring.cloud.stream.binder.servicebus.core.properties.ServiceBusExtendedBindingProperties;
import com.azure.spring.cloud.stream.binder.servicebus.implementation.ServiceBusMessageChannelBinder;
import com.azure.spring.cloud.stream.binder.servicebus.implementation.config.ServiceBusBinderHealthIndicatorConfiguration;
import com.azure.spring.cloud.stream.binder.servicebus.implementation.provisioning.ServiceBusChannelResourceManagerProvisioner;
import com.azure.spring.messaging.converter.AzureMessageConverter;
import com.azure.spring.messaging.servicebus.core.DefaultServiceBusNamespaceProcessorFactory;
import com.azure.spring.messaging.servicebus.core.DefaultServiceBusNamespaceProducerFactory;
import com.azure.spring.messaging.servicebus.core.ServiceBusProcessorFactory;
import com.azure.spring.messaging.servicebus.core.ServiceBusProducerFactory;
import com.azure.spring.messaging.servicebus.core.properties.NamespaceProperties;
import com.azure.spring.messaging.servicebus.implementation.support.converter.ServiceBusMessageConverter;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.binder.Binder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration(proxyBeanMethods=false)
@ConditionalOnMissingBean(value={Binder.class})
@Import(value={AzureGlobalPropertiesAutoConfiguration.class, AzureTokenCredentialAutoConfiguration.class, AzureResourceManagerAutoConfiguration.class, AzureServiceBusResourceManagerAutoConfiguration.class, AzureServiceBusAutoConfiguration.class, AzureServiceBusMessagingAutoConfiguration.class, ServiceBusBinderHealthIndicatorConfiguration.class})
@EnableConfigurationProperties(value={ServiceBusExtendedBindingProperties.class})
public class ServiceBusBinderConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={ServiceBusProvisioner.class, AzureServiceBusProperties.class})
    ServiceBusChannelProvisioner serviceBusChannelArmProvisioner(AzureServiceBusProperties serviceBusProperties, ServiceBusProvisioner serviceBusProvisioner) {
        return new ServiceBusChannelResourceManagerProvisioner(serviceBusProperties.getNamespace(), serviceBusProvisioner);
    }

    @Bean
    @ConditionalOnMissingBean(value={ServiceBusProvisioner.class, ServiceBusChannelProvisioner.class})
    ServiceBusChannelProvisioner serviceBusChannelProvisioner() {
        return new ServiceBusChannelProvisioner();
    }

    @Bean
    @ConditionalOnMissingBean
    ServiceBusMessageChannelBinder serviceBusBinder(ServiceBusChannelProvisioner channelProvisioner, ServiceBusExtendedBindingProperties bindingProperties, ObjectProvider<NamespaceProperties> namespaceProperties, ObjectProvider<ServiceBusMessageConverter> messageConverter, ObjectProvider<ServiceBusProducerFactoryCustomizer> producerFactoryCustomizers, ObjectProvider<ServiceBusProcessorFactoryCustomizer> processorFactoryCustomizers) {
        ServiceBusMessageChannelBinder binder = new ServiceBusMessageChannelBinder(null, channelProvisioner);
        binder.setBindingProperties(bindingProperties);
        binder.setNamespaceProperties((NamespaceProperties)namespaceProperties.getIfAvailable());
        binder.setMessageConverter((AzureMessageConverter<ServiceBusReceivedMessage, ServiceBusMessage>)((AzureMessageConverter)messageConverter.getIfAvailable()));
        producerFactoryCustomizers.orderedStream().forEach(binder::addProducerFactoryCustomizer);
        processorFactoryCustomizers.orderedStream().forEach(binder::addProcessorFactoryCustomizer);
        return binder;
    }

    @Bean
    @ConditionalOnMissingBean
    ServiceBusProducerFactoryCustomizer defaultServiceBusProducerFactoryCustomizer(AzureTokenCredentialResolver azureTokenCredentialResolver, @Qualifier(value="springCloudAzureDefaultCredential") TokenCredential defaultAzureCredential, ObjectProvider<AzureServiceClientBuilderCustomizer<ServiceBusClientBuilder.ServiceBusSenderClientBuilder>> senderClientBuilderCustomizers) {
        return new DefaultProducerFactoryCustomizer(defaultAzureCredential, azureTokenCredentialResolver, senderClientBuilderCustomizers);
    }

    @Bean
    @ConditionalOnMissingBean
    ServiceBusProcessorFactoryCustomizer defaultServiceBusProcessorFactoryCustomizer(AzureTokenCredentialResolver azureTokenCredentialResolver, @Qualifier(value="springCloudAzureDefaultCredential") TokenCredential defaultAzureCredential, ObjectProvider<AzureServiceClientBuilderCustomizer<ServiceBusClientBuilder.ServiceBusProcessorClientBuilder>> processorClientBuilderCustomizers, ObjectProvider<AzureServiceClientBuilderCustomizer<ServiceBusClientBuilder.ServiceBusSessionProcessorClientBuilder>> sessionProcessorClientBuilderCustomizers) {
        return new DefaultProcessorFactoryCustomizer(defaultAzureCredential, azureTokenCredentialResolver, processorClientBuilderCustomizers, sessionProcessorClientBuilderCustomizers);
    }

    static class DefaultProducerFactoryCustomizer
    implements ServiceBusProducerFactoryCustomizer {
        private final TokenCredential defaultCredential;
        private final AzureTokenCredentialResolver tokenCredentialResolver;
        private final ObjectProvider<AzureServiceClientBuilderCustomizer<ServiceBusClientBuilder.ServiceBusSenderClientBuilder>> senderClientBuilderCustomizers;

        DefaultProducerFactoryCustomizer(TokenCredential defaultCredential, AzureTokenCredentialResolver azureTokenCredentialResolver, ObjectProvider<AzureServiceClientBuilderCustomizer<ServiceBusClientBuilder.ServiceBusSenderClientBuilder>> senderClientBuilderCustomizers) {
            this.defaultCredential = defaultCredential;
            this.tokenCredentialResolver = azureTokenCredentialResolver;
            this.senderClientBuilderCustomizers = senderClientBuilderCustomizers;
        }

        @Override
        public void customize(ServiceBusProducerFactory factory) {
            if (factory instanceof DefaultServiceBusNamespaceProducerFactory) {
                DefaultServiceBusNamespaceProducerFactory defaultFactory = (DefaultServiceBusNamespaceProducerFactory)factory;
                defaultFactory.setDefaultCredential(this.defaultCredential);
                defaultFactory.setTokenCredentialResolver((AzureCredentialResolver)this.tokenCredentialResolver);
                this.senderClientBuilderCustomizers.orderedStream().forEach(arg_0 -> ((DefaultServiceBusNamespaceProducerFactory)defaultFactory).addBuilderCustomizer(arg_0));
            }
        }

        ObjectProvider<AzureServiceClientBuilderCustomizer<ServiceBusClientBuilder.ServiceBusSenderClientBuilder>> getSenderClientBuilderCustomizers() {
            return this.senderClientBuilderCustomizers;
        }
    }

    static class DefaultProcessorFactoryCustomizer
    implements ServiceBusProcessorFactoryCustomizer {
        private final TokenCredential defaultCredential;
        private final AzureTokenCredentialResolver tokenCredentialResolver;
        private final ObjectProvider<AzureServiceClientBuilderCustomizer<ServiceBusClientBuilder.ServiceBusProcessorClientBuilder>> processorClientBuilderCustomizers;
        private final ObjectProvider<AzureServiceClientBuilderCustomizer<ServiceBusClientBuilder.ServiceBusSessionProcessorClientBuilder>> sessionProcessorClientBuilderCustomizers;

        DefaultProcessorFactoryCustomizer(TokenCredential defaultCredential, AzureTokenCredentialResolver azureTokenCredentialResolver, ObjectProvider<AzureServiceClientBuilderCustomizer<ServiceBusClientBuilder.ServiceBusProcessorClientBuilder>> processorClientBuilderCustomizers, ObjectProvider<AzureServiceClientBuilderCustomizer<ServiceBusClientBuilder.ServiceBusSessionProcessorClientBuilder>> sessionProcessorClientBuilderCustomizers) {
            this.defaultCredential = defaultCredential;
            this.tokenCredentialResolver = azureTokenCredentialResolver;
            this.processorClientBuilderCustomizers = processorClientBuilderCustomizers;
            this.sessionProcessorClientBuilderCustomizers = sessionProcessorClientBuilderCustomizers;
        }

        @Override
        public void customize(ServiceBusProcessorFactory factory) {
            if (factory instanceof DefaultServiceBusNamespaceProcessorFactory) {
                DefaultServiceBusNamespaceProcessorFactory defaultFactory = (DefaultServiceBusNamespaceProcessorFactory)factory;
                defaultFactory.setDefaultCredential(this.defaultCredential);
                defaultFactory.setTokenCredentialResolver((AzureCredentialResolver)this.tokenCredentialResolver);
                this.processorClientBuilderCustomizers.orderedStream().forEach(arg_0 -> ((DefaultServiceBusNamespaceProcessorFactory)defaultFactory).addBuilderCustomizer(arg_0));
                this.sessionProcessorClientBuilderCustomizers.orderedStream().forEach(arg_0 -> ((DefaultServiceBusNamespaceProcessorFactory)defaultFactory).addSessionBuilderCustomizer(arg_0));
            }
        }

        ObjectProvider<AzureServiceClientBuilderCustomizer<ServiceBusClientBuilder.ServiceBusProcessorClientBuilder>> getProcessorClientBuilderCustomizers() {
            return this.processorClientBuilderCustomizers;
        }

        ObjectProvider<AzureServiceClientBuilderCustomizer<ServiceBusClientBuilder.ServiceBusSessionProcessorClientBuilder>> getSessionProcessorClientBuilderCustomizers() {
            return this.sessionProcessorClientBuilderCustomizers;
        }
    }
}

