/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.tracing.sleuth;

import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.UrlBuilder;
import com.azure.spring.tracing.sleuth.implementation.HttpTraceUtil;
import com.azure.spring.tracing.sleuth.implementation.TraceContextUtil;
import java.net.URL;
import java.util.Optional;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.TraceContext;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.propagation.Propagator;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Signal;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

public class SleuthHttpPolicy
implements HttpPipelinePolicy {
    private final Tracer tracer;
    private final Propagator propagator;
    private static final String HTTP_USER_AGENT = "http.user_agent";
    private static final String HTTP_METHOD = "http.method";
    private static final String HTTP_URL = "http.url";
    private static final String HTTP_STATUS_CODE = "http.status_code";
    private static final String REQUEST_ID = "x-ms-request-id";
    private static final String AZ_NAMESPACE_KEY = "az.namespace";
    private final Propagator.Setter<HttpRequest> contextSetter = (request, key, value) -> request.getHeaders().set(key, value);

    public SleuthHttpPolicy(Tracer tracer, Propagator propagator) {
        Assert.notNull((Object)tracer, (String)"tracer must not be null!");
        Assert.notNull((Object)propagator, (String)"propagator must not be null!");
        this.tracer = tracer;
        this.propagator = propagator;
    }

    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        TraceContext traceContext;
        if (context.getData("disable-tracing").orElse(false).booleanValue()) {
            return next.process();
        }
        Span parentSpan = context.getData("trace-context").orElse(this.tracer.currentSpan());
        HttpRequest request = context.getHttpRequest();
        UrlBuilder urlBuilder = UrlBuilder.parse((URL)context.getHttpRequest().getUrl());
        Span.Builder spanBuilder = this.tracer.spanBuilder().name(urlBuilder.getPath()).setParent(parentSpan.context());
        spanBuilder.kind(Span.Kind.CLIENT);
        Span span = spanBuilder.start();
        if (!span.isNoop()) {
            SleuthHttpPolicy.addSpanRequestAttributes(span, request, context);
        }
        if (TraceContextUtil.isValid(traceContext = span.context())) {
            this.propagator.inject(traceContext, (Object)request, this.contextSetter);
        }
        return next.process().doOnEach(SleuthHttpPolicy::handleResponse).contextWrite((ContextView)Context.of((Object)"TRACING_SPAN", (Object)span));
    }

    private static void addSpanRequestAttributes(Span span, HttpRequest request, HttpPipelineCallContext context) {
        SleuthHttpPolicy.putTagIfNotEmptyOrNull(span, HTTP_USER_AGENT, request.getHeaders().getValue("User-Agent"));
        SleuthHttpPolicy.putTagIfNotEmptyOrNull(span, HTTP_METHOD, request.getHttpMethod().toString());
        SleuthHttpPolicy.putTagIfNotEmptyOrNull(span, HTTP_URL, request.getUrl().toString());
        Optional tracingNamespace = context.getData(AZ_NAMESPACE_KEY);
        tracingNamespace.ifPresent(o -> SleuthHttpPolicy.putTagIfNotEmptyOrNull(span, AZ_NAMESPACE_KEY, o.toString()));
    }

    private static void putTagIfNotEmptyOrNull(Span span, String key, String value) {
        if (!CoreUtils.isNullOrEmpty((CharSequence)value)) {
            span.tag(key, value);
        }
    }

    private static void handleResponse(Signal<? extends HttpResponse> signal) {
        if (signal.isOnComplete() || signal.isOnSubscribe()) {
            return;
        }
        ContextView context = signal.getContextView();
        Optional tracingSpan = context.getOrEmpty((Object)"TRACING_SPAN");
        if (!tracingSpan.isPresent()) {
            return;
        }
        Span span = (Span)tracingSpan.get();
        HttpResponse httpResponse = null;
        Throwable error = null;
        if (signal.isOnNext()) {
            httpResponse = (HttpResponse)signal.get();
        } else {
            error = signal.getThrowable();
            if (error instanceof HttpResponseException) {
                HttpResponseException exception = (HttpResponseException)error;
                httpResponse = exception.getResponse();
            }
        }
        SleuthHttpPolicy.spanEnd(span, httpResponse, error);
    }

    private static void spanEnd(Span span, HttpResponse response, Throwable error) {
        if (!span.isNoop()) {
            int statusCode = 0;
            String requestId = null;
            if (response != null) {
                statusCode = response.getStatusCode();
                requestId = response.getHeaderValue(REQUEST_ID);
            }
            SleuthHttpPolicy.putTagIfNotEmptyOrNull(span, REQUEST_ID, requestId);
            span.tag(HTTP_STATUS_CODE, String.valueOf(statusCode));
            span = HttpTraceUtil.setSpanStatus(span, statusCode, error);
        }
        span.end();
    }
}

