/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.tracing.sleuth.implementation;

import com.azure.spring.tracing.sleuth.implementation.HttpStatus;
import org.springframework.cloud.sleuth.Span;

public final class HttpTraceUtil {
    public static Span setSpanStatus(Span span, int statusCode, Throwable throwable) {
        if (throwable != null) {
            return span.error(throwable);
        }
        if (statusCode >= 200 && statusCode < 400) {
            return span;
        }
        HttpStatus status = HttpStatus.resolve(statusCode);
        if (status != null) {
            return span.tag("http.status_message", status.getReasonPhrase());
        }
        return span;
    }
}

