/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.tracing.sleuth.implementation;

import com.azure.spring.tracing.sleuth.implementation.TraceContextUtil;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class SpanId {
    private static final ThreadLocal<char[]> CHAR_BUFFER = new ThreadLocal();
    private static final int BYTES_LENGTH = 8;
    private static final int HEX_LENGTH = 16;
    private static final String INVALID = "0000000000000000";

    public static int getLength() {
        return 16;
    }

    public static String getInvalid() {
        return INVALID;
    }

    public static boolean isValid(CharSequence spanId) {
        return spanId != null && spanId.length() == 16 && !INVALID.contentEquals(spanId) && TraceContextUtil.isValidBase16String(spanId);
    }
}

