/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.tracing.sleuth.implementation;

import com.azure.spring.tracing.sleuth.implementation.TraceContextUtil;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TraceId {
    private static final ThreadLocal<char[]> CHAR_BUFFER = new ThreadLocal();
    private static final int BYTES_LENGTH = 16;
    private static final int HEX_LENGTH = 32;
    private static final String INVALID = "00000000000000000000000000000000";

    public static int getLength() {
        return 32;
    }

    public static String getInvalid() {
        return INVALID;
    }

    public static boolean isValid(CharSequence traceId) {
        return traceId != null && traceId.length() == 32 && !INVALID.contentEquals(traceId) && TraceContextUtil.isValidBase16String(traceId);
    }
}

