/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.integration.servicebus.inbound.health;

import com.azure.messaging.servicebus.ServiceBusErrorContext;
import com.azure.spring.integration.instrumentation.Instrumentation;
import java.time.Duration;

public class ServiceBusProcessorInstrumentation
implements Instrumentation {
    private final String name;
    private final Instrumentation.Type type;
    private long lastErrorTimestamp = Long.MIN_VALUE;
    private final Duration noneErrorWindow;
    private ServiceBusErrorContext errorContext;

    public ServiceBusProcessorInstrumentation(String name, Instrumentation.Type type, Duration noneErrorWindow) {
        this.name = name;
        this.type = type;
        this.noneErrorWindow = noneErrorWindow;
    }

    public Instrumentation.Type getType() {
        return this.type;
    }

    public Throwable getException() {
        return this.errorContext == null ? null : this.errorContext.getException();
    }

    public boolean isDown() {
        if (System.currentTimeMillis() > this.lastErrorTimestamp + this.noneErrorWindow.toMillis()) {
            this.errorContext = null;
            return false;
        }
        return true;
    }

    public boolean isUp() {
        return !this.isDown();
    }

    public void markError(ServiceBusErrorContext errorContext) {
        this.errorContext = errorContext;
        this.lastErrorTimestamp = System.currentTimeMillis();
    }

    public ServiceBusErrorContext getErrorContext() {
        return this.errorContext;
    }

    public String getName() {
        return this.name;
    }
}

