/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.integration.storage.queue.inbound;

import com.azure.spring.storage.queue.core.StorageQueueTemplate;
import org.springframework.integration.endpoint.AbstractMessageSource;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class StorageQueueMessageSource
extends AbstractMessageSource<Message<?>> {
    private final StorageQueueTemplate storageQueueTemplate;
    private final String destination;

    public StorageQueueMessageSource(String destination, StorageQueueTemplate storageQueueTemplate) {
        Assert.hasText((String)destination, (String)"destination can't be null or empty");
        this.storageQueueTemplate = storageQueueTemplate;
        this.destination = destination;
    }

    public Object doReceive() {
        return this.storageQueueTemplate.receiveAsync(this.destination, null).block();
    }

    public String getComponentType() {
        return "storage-queue:message-source";
    }
}

