/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.eventhubs.checkpoint;

import com.azure.messaging.eventhubs.models.EventContext;
import com.azure.spring.eventhubs.checkpoint.EventCheckpointManager;
import com.azure.spring.messaging.checkpoint.CheckpointConfig;
import com.azure.spring.messaging.checkpoint.CheckpointMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

class RecordCheckpointManager
extends EventCheckpointManager {
    private static final Logger LOG = LoggerFactory.getLogger(RecordCheckpointManager.class);

    RecordCheckpointManager(CheckpointConfig checkpointConfig) {
        super(checkpointConfig);
        Assert.isTrue((this.checkpointConfig.getMode() == CheckpointMode.RECORD ? 1 : 0) != 0, () -> "RecordCheckpointManager should have checkpointMode record");
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    public void checkpoint(EventContext context) {
        context.updateCheckpointAsync().doOnError(t -> this.logCheckpointFail(context, context.getEventData(), (Throwable)t)).doOnSuccess(v -> this.logCheckpointSuccess(context, context.getEventData())).subscribe();
    }
}

